/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen.util;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.datagen.BlockModel;
import net.lixir.vminus.registry.TintType;
import net.lixir.vminus.registry.VRegistry;
import net.lixir.vminus.registry.entry.BlockEntry;
import net.lixir.vminus.registry.entry.accessor.BlockEntryAccessor;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class VBlockStateProvider
extends BlockStateProvider {
    public final String modId;
    private static final List<String> AUTO_PLURALIZE = List.of("brick", "plank");

    public VBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper, String modId) {
        super(output, modId, exFileHelper);
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    protected void registerStatesAndModels() {
        List<Block> blocks = VRegistry.fromId(this.modId).getBlocks();
        for (Block block : blocks) {
            BlockEntryAccessor accessor = (BlockEntryAccessor)block;
            BlockEntry blockEntry = accessor.vminus$getEntry();
            if (blockEntry == null) continue;
            BlockModel model = blockEntry.getModel();
            VMinus.LOGGER.debug("Generating model {} for block {}", (Object)model, (Object)block);
            model.apply(block, blockEntry, this);
        }
    }

    public void carpet(Block block, String modelTextureSuffix, @NotNull ResourceLocation modelTextureOverride) {
        String blockPath = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
        ResourceLocation texture = modelTextureOverride.equals((Object)BlockEntry.UNSET_RESOURCE_LOCATION) ? this.textureFromBlock(block, "_carpet", modelTextureSuffix) : modelTextureOverride;
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(blockPath, new ResourceLocation("minecraft", "block/carpet"))).texture("wool", texture));
    }

    public void lantern(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ResourceLocation texture = this.blockTexture(block);
        ModelBuilder standingModel = ((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/template_lantern"))).texture("lantern", texture);
        ModelBuilder hangingModel = ((BlockModelBuilder)this.models().withExistingParent(name + "_hanging", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", texture);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)standingModel).addModel()).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)hangingModel).addModel();
        this.itemModels().basicItem(this.modLoc(name));
    }

    public void torch(RegistryObject<Block> block) {
        this.torch(block);
    }

    public void torch(Block block) {
        String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(blockPath, new ResourceLocation("block/template_torch"))).texture("torch", this.blockTexture(block)));
    }

    public void pinkPetals(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        MultiPartBlockStateBuilder multipartBuilder = this.getMultipartBuilder(block);
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        int[] rotations = new int[]{0, 90, 180, 270};
        int maxFlowerAmount = 4;
        Property facingProp = block.m_49965_().m_61081_(BlockStateProperties.f_61372_.m_61708_());
        Property flowerAmountProp = block.m_49965_().m_61081_("flower_amount");
        for (int flowerAmount = 1; flowerAmount <= maxFlowerAmount; ++flowerAmount) {
            for (int petal = 1; petal <= flowerAmount; ++petal) {
                String modelName = this.modId + ":block/" + name + "_" + petal;
                for (int d = 0; d < directions.length; ++d) {
                    Direction facing = directions[d];
                    int yRotation = rotations[d];
                    ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation(modelName))).rotationY(yRotation).addModel()).condition(facingProp, (Comparable[])new Direction[]{facing}).condition(flowerAmountProp, (Comparable[])new Integer[]{flowerAmount});
                }
            }
        }
    }

    public void wallTorch(Block block, String modelTextureSuffix) {
        ResourceLocation wallTorchLocation = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String wallTorchPath = wallTorchLocation.m_135815_();
        String torchName = wallTorchPath.replaceAll(modelTextureSuffix, "");
        Block torch = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(wallTorchLocation.m_135827_(), torchName));
        ResourceLocation texture = this.blockTexture(torch);
        ModelBuilder wallTorchModel = this.models().torchWall(wallTorchPath, texture);
        this.getVariantBuilder(block).forAllStates(arg_0 -> VBlockStateProvider.lambda$wallTorch$0((ModelFile)wallTorchModel, arg_0));
    }

    public void stainedGlassPane(Block block) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        String path = resourceLocation.m_135815_();
        String glassPath = path.substring(0, path.indexOf("_pane"));
    }

    public void allSidedCube(Block block, String renderType) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(resourceLocation.m_135815_(), this.modLoc("block/" + resourceLocation.m_135815_()))).renderType(renderType));
    }

    public void tintedAllSidedCube(Block block, String renderType) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().leaves(resourceLocation.m_135815_(), this.modLoc("block/" + resourceLocation.m_135815_()))).renderType(renderType));
    }

    public void allSidedCubeWithItem(Block block, String renderType) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(resourceLocation.m_135815_(), this.modLoc("block/" + resourceLocation.m_135815_()))).renderType(renderType));
    }

    public void allSidedCubeWithItem(Block block, RegistryObject<Block> registryObject) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().cubeAll(registryObject.getId().m_135815_(), this.modLoc("block/" + registryObject.getId().m_135815_())));
    }

    public void translucentCubeWithItem(Block block) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(resourceLocation.m_135815_(), this.modLoc("block/" + resourceLocation.m_135815_()))).renderType("translucent"));
    }

    public void translucentCubeWithItem(Block block, RegistryObject<Block> registryObject) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().cubeAll(registryObject.getId().m_135815_(), this.modLoc("block/" + registryObject.getId().m_135815_())));
    }

    public void translucentCubeWithItem(RegistryObject<Block> registryObject) {
        this.translucentCubeWithItem((Block)registryObject.get(), registryObject);
    }

    public void registerLeaves(Block block) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().singleTexture(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_(), new ResourceLocation("minecraft:block/leaves"), "all", this.blockTexture(block)));
    }

    public void variedCross(Block block) {
        String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(blockPath, new ResourceLocation("vminus", "block/varied_cross"))).texture("cross", this.blockTexture(block)));
    }

    public void veinBlock(RegistryObject<Block> registryObject) {
        this.veinBlock((Block)registryObject.get());
    }

    public void woodBlock(Block block, String modelTextureSuffix) {
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
        ResourceLocation texture = this.textureFromBlock(block, "_wood", modelTextureSuffix);
        ModelBuilder model = this.models().cubeAll(name, texture);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).addModel();
        this.simpleBlockItem(block, (ModelFile)model);
    }

    public void axis(Block block) {
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
        ResourceLocation texture = this.modLoc("block/" + name);
        ResourceLocation endTexture = this.modLoc("block/" + name + "_top");
        ModelBuilder vertical = this.models().cubeColumn(name, texture, endTexture);
        ModelBuilder horizontal = this.models().cubeColumnHorizontal(name + "_horizontal", texture, endTexture);
        this.getVariantBuilder(block).forAllStates(arg_0 -> VBlockStateProvider.lambda$axis$1((ModelFile)vertical, (ModelFile)horizontal, arg_0));
    }

    public void veinBlock(Block block) {
        String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(blockPath, new ResourceLocation("minecraft", "block/sculk_vein"))).texture("sculk_vein", this.blockTexture(block)));
    }

    public void cubeColumn(Block block) {
        String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockPath, new ResourceLocation("minecraft", "block/cube_column"))).texture("side", this.blockTexture(block))).texture("end", new ResourceLocation(this.blockTexture(block).m_135827_(), this.blockTexture(block).m_135815_() + "_top")));
    }

    public void cubeBottomTop(Block block) {
        String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        ResourceLocation baseTexture = this.blockTexture(block);
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockPath, new ResourceLocation("minecraft", "block/cube_bottom_top"))).texture("top", new ResourceLocation(baseTexture.m_135827_(), baseTexture.m_135815_() + "_top"))).texture("bottom", new ResourceLocation(baseTexture.m_135827_(), baseTexture.m_135815_() + "_bottom"))).texture("side", baseTexture));
    }

    public void cross(Block block, String renderType, TintType tintType) {
        if (tintType == TintType.NONE) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture(block).m_135815_(), this.blockTexture(block))).renderType(renderType));
        } else {
            ResourceLocation resourceLocation = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            String name = resourceLocation.m_135815_();
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/tinted_cross"))).texture("cross", this.blockTexture(block))).renderType(renderType));
        }
    }

    public void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.modId + ":block/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_()));
    }

    public void doubleCross(Block block, @NotNull String renderType, @NotNull TintType tintType) {
        String modelPath = tintType == TintType.NONE ? "block/cross" : "block/tinted_cross";
        ResourceLocation resourceLocation = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String name = resourceLocation.m_135815_();
        ResourceLocation topTexture = this.modLoc("block/" + name + "_top");
        ResourceLocation bottomTexture = this.modLoc("block/" + name + "_bottom");
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_lower", new ResourceLocation("minecraft", modelPath))).texture("cross", bottomTexture)).renderType(renderType)).addModel()).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_upper", new ResourceLocation("minecraft", modelPath))).texture("cross", topTexture)).renderType(renderType)).addModel();
    }

    private ResourceLocation getSuffixedBlockTexture(@NotNull ResourceLocation override, String blockPath, String addSuffix, String removeSuffix) {
        if (!override.equals((Object)BlockEntry.UNSET_RESOURCE_LOCATION)) {
            return override;
        }
        return this.modLoc("block/" + this.formSuffixedTexturePath(blockPath, removeSuffix) + addSuffix);
    }

    private String formSuffixedTexturePath(@NotNull String blockId, String removeSuffix) {
        String base = blockId.endsWith(removeSuffix) ? blockId.substring(0, blockId.length() - removeSuffix.length()) : blockId;
        for (String pluralize : AUTO_PLURALIZE) {
            if (!base.endsWith(pluralize)) continue;
            return base + "s";
        }
        return base;
    }

    public void wall(Block block, String modelTextureSuffix, ResourceLocation modelTextureOverride) {
        this.wall(block, "solid", modelTextureSuffix, modelTextureOverride);
    }

    public void wall(Block block, String renderType, String modelTextureSuffix, ResourceLocation modelTextureOverride) {
        String id = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
        ResourceLocation texture = this.getSuffixedBlockTexture(modelTextureOverride, id, modelTextureSuffix, "_wall");
        this.wallBlockWithRenderType((WallBlock)block, texture, renderType);
        this.itemModels().wallInventory(id, texture);
    }

    protected ResourceLocation getSuffixedBlockTexture(ResourceLocation modelTextureOverride, Block block, String modelTextureSuffix, String removeSuffix) {
        String id = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
        return this.getSuffixedBlockTexture(modelTextureOverride, id, modelTextureSuffix, removeSuffix);
    }

    public void registerDirtGrassBlock(Block block, ResourceLocation topTexture, ResourceLocation sideTexture, ResourceLocation overlayTexture) {
        this.registerTemplateGrassBlock(block, new ResourceLocation("minecraft", "block/dirt"), topTexture, sideTexture, overlayTexture);
    }

    public void registerTemplateGrassBlock(Block block, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation sideTexture, ResourceLocation overlayTexture) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), new ResourceLocation("minecraft", "block/grass_block"))).texture("bottom", bottomTexture)).texture("particle", bottomTexture)).texture("top", topTexture)).texture("side", sideTexture)).texture("overlay", overlayTexture));
        String blockPath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.itemModels().withExistingParent(blockPath, this.getModId() + ":block/" + blockPath);
    }

    public void stairs(Block block, String textureSuffix, ResourceLocation modelTextureOverride) {
        this.stairs(block, "solid", textureSuffix, modelTextureOverride);
    }

    public void stairs(Block block, String renderType, String textureSuffix, ResourceLocation modelTextureOverride) {
        String id = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ResourceLocation texture = this.getSuffixedBlockTexture(modelTextureOverride, id, textureSuffix, "_stairs");
        this.stairsBlockWithRenderType((StairBlock)block, texture, renderType);
        this.itemModels().withExistingParent(id, this.modLoc("block/" + id));
    }

    public void air(Block block) {
        String path = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(path);
        this.simpleBlock(block, (ModelFile)model);
    }

    public void slab(Block block, String modelTextureSuffix, ResourceLocation modelTextureOverride) {
        this.slab(block, "solid", modelTextureSuffix, modelTextureOverride);
    }

    public void slab(Block block, String renderType, String textureSuffix, ResourceLocation modelTextureOverride) {
        String id = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ResourceLocation texture = this.getSuffixedBlockTexture(modelTextureOverride, id, textureSuffix, "_slab");
        SlabBlock slabBlock = (SlabBlock)block;
        BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)this.models().slab(id, texture, texture, texture)).renderType(renderType);
        BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)this.models().slabTop(id + "_top", texture, texture, texture)).renderType(renderType);
        BlockModelBuilder doubleSlab = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeAll(id + "_double", texture)).renderType(renderType);
        this.getVariantBuilder((Block)slabBlock).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottom)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)top)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleSlab)});
        this.itemModels().withExistingParent(id, this.modLoc("block/" + id));
    }

    public void door(Block block) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String namespace = id.m_135827_();
        String path = id.m_135815_();
        ResourceLocation bottomTexture = new ResourceLocation(namespace, "block/" + path + "_bottom");
        ResourceLocation topTexture = new ResourceLocation(namespace, "block/" + path + "_top");
        this.doorBlock((DoorBlock)block, bottomTexture, topTexture);
    }

    public void trapdoor(Block block) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String namespace = id.m_135827_();
        String path = id.m_135815_();
        ResourceLocation texture = new ResourceLocation(namespace, "block/" + path);
        this.trapdoorBlock((TrapDoorBlock)block, texture, false);
        this.itemModels().trapdoorBottom(path, texture);
    }

    public void sign(Block block, String modelTextureSuffix) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String namespace = id.m_135827_();
        String path = id.m_135815_();
        if (path.endsWith("_sign")) {
            path = path.substring(0, path.indexOf("_sign"));
        }
        if (path.endsWith("_hanging")) {
            path = path.substring(0, path.indexOf("_hanging"));
        }
        if (path.endsWith("_wall")) {
            path = path.substring(0, path.indexOf("_wall"));
        }
        ResourceLocation texture = new ResourceLocation(namespace, "block/" + path + modelTextureSuffix);
        ModelBuilder sign = this.models().sign(this.name(block), texture);
        this.simpleBlock(block, (ModelFile)sign);
    }

    public void pressurePlate(Block block, String modelTextureSuffix) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ResourceLocation texture = this.textureFromBlock(block, "_pressure_plate", modelTextureSuffix);
        this.pressurePlateBlock((PressurePlateBlock)block, texture);
        this.itemModels().pressurePlate(name, texture);
    }

    public void button(Block block, String modelTextureSuffix) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ResourceLocation texture = this.textureFromBlock(block, "_button", modelTextureSuffix);
        this.buttonBlock((ButtonBlock)block, texture);
        this.itemModels().buttonInventory(name, texture);
    }

    public void fenceGateBlock(Block block, String modelTextureSuffix) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ResourceLocation texture = this.textureFromBlock(block, "_fence_gate", modelTextureSuffix);
        this.fenceGateBlock((FenceGateBlock)block, texture);
        this.itemModels().fenceGate(name, texture);
    }

    public void fenceBlock(Block block, String modelTextureSuffix) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ResourceLocation texture = this.textureFromBlock(block, "_fence", modelTextureSuffix);
        this.fenceBlock((FenceBlock)block, texture);
        this.itemModels().fenceInventory(name, texture);
    }

    public ResourceLocation textureFromBlock(Block block, String lookFor, String modelTextureSuffix) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String namespace = id.m_135827_();
        String path = id.m_135815_();
        String trimPath = path.substring(0, path.indexOf(lookFor)) + modelTextureSuffix;
        return new ResourceLocation(namespace, "block/" + trimPath);
    }

    public void simpleBlockWithItem(Block block, ModelFile model) {
        this.simpleBlock(block, model);
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_())).parent(model);
    }

    public String name(Block block) {
        return this.key(block).m_135815_();
    }

    public ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public <T> Optional<T> as(@NotNull Class<T> clazz) {
        return clazz.isInstance((Object)this) ? Optional.of(clazz.cast((Object)this)) : Optional.empty();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$axis$1(ModelFile vertical, ModelFile horizontal, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
        return ConfiguredModel.builder().modelFile(axis == Direction.Axis.Y ? vertical : horizontal).rotationX(axis == Direction.Axis.X ? 90 : (axis == Direction.Axis.Z ? 90 : 0)).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$wallTorch$0(ModelFile wallTorchModel, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)WallTorchBlock.f_58119_);
        int rotY = (int)dir.m_122427_().m_122435_();
        return ConfiguredModel.builder().modelFile(wallTorchModel).rotationY(rotY).build();
    }
}

