/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import net.lixir.vminus.resources.data.RoleManager;
import net.lixir.vminus.roles.RoleSavedData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class RoleCommand {
    private static final SuggestionProvider<CommandSourceStack> ROLE_SUGGESTIONS = (ctx, builder) -> {
        Set<String> roles = RoleManager.INSTANCE.getAllRoleNames();
        roles.add("none");
        return SharedSuggestionProvider.m_82970_(roles, (SuggestionsBuilder)builder);
    };

    @SubscribeEvent
    public static void register(@NotNull RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"role").requires(source -> source.m_6761_(4))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"role", (ArgumentType)StringArgumentType.word()).suggests(ROLE_SUGGESTIONS).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            String role = StringArgumentType.getString((CommandContext)ctx, (String)"role");
            RoleSavedData data = RoleSavedData.get(player.m_9236_());
            if (role.equalsIgnoreCase("none")) {
                data.removeRole(player);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed role from " + player.m_7755_().getString())), true);
                return 1;
            }
            if (RoleManager.INSTANCE.getRole(role) == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown role: " + role)));
                return 0;
            }
            data.setRole(player, role);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Assigned role '" + role + "' to " + player.m_7755_().getString())), true);
            return 1;
        }))));
    }
}

