/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.audio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.sound.sampled.AudioFormat;
import net.lixir.vminus.VMinus;
import net.minecraft.client.sounds.AudioStream;
import org.jetbrains.annotations.NotNull;
import vminus.shadow.org.concentus.OpusDecoder;
import vminus.shadow.org.concentus.OpusException;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.ogg.OggPacketReader;

public class OggOpusAudioStream
implements AudioStream {
    private static final int SAMPLE_RATE = 48000;
    private static final int FRAME_SIZE = 960;
    private AudioFormat format;
    private OpusDecoder decoder;
    private short[] decodeBuffer;
    private final ByteBuffer outputBuffer;
    private final OggPacketReader reader;
    private boolean closed = false;
    private final InputStream sourceStream;
    private boolean initialized = false;
    private int channels = 1;

    public OggOpusAudioStream(InputStream stream) throws IOException {
        this.sourceStream = stream;
        this.reader = new OggPacketReader(stream);
        this.outputBuffer = ByteBuffer.allocateDirect(16384);
        this.outputBuffer.flip();
    }

    @NotNull
    public AudioFormat m_6206_() {
        if (this.format == null) {
            return new AudioFormat(48000.0f, 16, 1, true, false);
        }
        return this.format;
    }

    public ByteBuffer readAll() throws IOException {
        ByteBuffer chunk;
        ByteBuffer all = ByteBuffer.allocateDirect(0x100000);
        while ((chunk = this.m_7118_(4096)).hasRemaining()) {
            if (all.remaining() < chunk.remaining()) {
                ByteBuffer newBuf = ByteBuffer.allocateDirect(all.capacity() + 524288);
                all.flip();
                newBuf.put(all);
                all = newBuf;
            }
            all.put(chunk);
        }
        all.flip();
        return all;
    }

    @NotNull
    public ByteBuffer m_7118_(int size) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        ByteBuffer result = ByteBuffer.allocateDirect(size);
        while (result.position() < size && (this.outputBuffer.hasRemaining() || this.decodeNextPacket())) {
            int toCopy = Math.min(this.outputBuffer.remaining(), size - result.position());
            ByteBuffer slice = this.outputBuffer.slice();
            slice.limit(toCopy);
            result.put(slice);
            this.outputBuffer.position(this.outputBuffer.position() + toCopy);
        }
        result.flip();
        return result;
    }

    private boolean decodeNextPacket() throws IOException {
        int samples;
        byte[] data;
        while (true) {
            OggPacket packet;
            if ((packet = this.reader.getNextPacket()) == null) {
                return false;
            }
            data = packet.getData();
            if (data.length >= 19 && new String(data, 0, 8, StandardCharsets.US_ASCII).equals("OpusHead")) {
                this.channels = data[9] & 0xFF;
                this.format = new AudioFormat(48000.0f, 16, this.channels, true, false);
                try {
                    this.decoder = new OpusDecoder(48000, this.channels);
                }
                catch (OpusException e) {
                    throw new IOException("Failed to init Opus decoder", e);
                }
                this.decodeBuffer = new short[960 * this.channels];
                this.initialized = true;
                continue;
            }
            if ((data.length < 8 || !new String(data, 0, 8, StandardCharsets.US_ASCII).equals("OpusTags")) && this.initialized) break;
        }
        try {
            samples = this.decoder.decode(data, 0, data.length, this.decodeBuffer, 0, 960, false);
        }
        catch (OpusException e) {
            throw new IOException("Opus decode error", e);
        }
        this.outputBuffer.clear();
        for (int i = 0; i < samples * this.channels; ++i) {
            short sample = this.decodeBuffer[i];
            this.outputBuffer.put((byte)(sample & 0xFF));
            this.outputBuffer.put((byte)(sample >> 8 & 0xFF));
        }
        this.outputBuffer.flip();
        return true;
    }

    public void close() {
        this.closed = true;
        try {
            this.sourceStream.close();
        }
        catch (IOException e) {
            VMinus.LOGGER.warn("Failed to close underlying Opus stream", (Throwable)e);
        }
    }
}

