/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class RunicMethods {
    public static void postHitRunicFreeze(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("freezeChance", "RunicEffects", ConfigDefaultValues.freezeChance);
        int freezeDuration = (int)Config.getFloat("freezeDuration", "RunicEffects", ConfigDefaultValues.freezeDuration);
        int duration = freezeDuration * 3;
        target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, duration, 1), (Entity)attacker);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZE.get(), freezeDuration, 1), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicWildfire(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("wildfireChance", "RunicEffects", ConfigDefaultValues.wildfireChance);
        int duration = (int)Config.getFloat("wildfireDuration", "RunicEffects", ConfigDefaultValues.wildfireDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.WILDFIRE.get(), duration, 3), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicSlow(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("slowChance", "RunicEffects", ConfigDefaultValues.slowChance);
        int duration = (int)Config.getFloat("slowDuration", "RunicEffects", ConfigDefaultValues.slowDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, duration, 1), (Entity)attacker);
        }
    }

    public static void postHitRunicGreaterSlow(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("slowChance", "RunicEffects", ConfigDefaultValues.slowChance);
        int duration = (int)Config.getFloat("slowDuration", "RunicEffects", ConfigDefaultValues.slowDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, duration, 2), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicSwiftness(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("swiftnessChance", "RunicEffects", ConfigDefaultValues.swiftnessChance);
        int duration = (int)Config.getFloat("swiftnessDuration", "RunicEffects", ConfigDefaultValues.swiftnessDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, duration, 0), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicGreaterSwiftness(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("swiftnessChance", "RunicEffects", ConfigDefaultValues.swiftnessChance);
        int duration = (int)Config.getFloat("swiftnessDuration", "RunicEffects", ConfigDefaultValues.swiftnessDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, duration, 1), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicFloat(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("floatChance", "RunicEffects", ConfigDefaultValues.floatChance);
        int duration = (int)Config.getFloat("floatDuration", "RunicEffects", ConfigDefaultValues.floatDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19620_, duration, 2), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicGreaterFloat(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("floatChance", "RunicEffects", ConfigDefaultValues.floatChance);
        int duration = (int)Config.getFloat("floatDuration", "RunicEffects", ConfigDefaultValues.floatDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19620_, duration, 3), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicZephyr(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("zephyrChance", "RunicEffects", ConfigDefaultValues.zephyrChance);
        int duration = (int)Config.getFloat("zephyrDuration", "RunicEffects", ConfigDefaultValues.zephyrDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, duration, 0), (Entity)attacker);
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, duration, 0), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicGreaterZephyr(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("zephyrChance", "RunicEffects", ConfigDefaultValues.zephyrChance);
        int duration = (int)Config.getFloat("zephyrDuration", "RunicEffects", ConfigDefaultValues.zephyrDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, duration, 1), (Entity)attacker);
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, duration, 1), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicShielding(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("shieldingChance", "RunicEffects", ConfigDefaultValues.shieldingChance);
        int duration = (int)Config.getFloat("shieldingDuration", "RunicEffects", ConfigDefaultValues.shieldingDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19617_, duration, 0), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicGreaterShielding(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("shieldingChance", "RunicEffects", ConfigDefaultValues.shieldingChance);
        int duration = (int)Config.getFloat("shieldingDuration", "RunicEffects", ConfigDefaultValues.shieldingDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19617_, duration, 1), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicStoneskin(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("stoneskinChance", "RunicEffects", ConfigDefaultValues.stoneskinChance);
        int duration = (int)Config.getFloat("stoneskinDuration", "RunicEffects", ConfigDefaultValues.stoneskinDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19606_, duration, 1), (Entity)attacker);
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19607_, duration, 0), (Entity)attacker);
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19597_, duration, 0), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_02.get(), attacker.m_5720_(), 0.3f, 1.3f);
        }
    }

    public static void postHitRunicGreaterStoneskin(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("stoneskinChance", "RunicEffects", ConfigDefaultValues.stoneskinChance);
        int duration = (int)Config.getFloat("stoneskinDuration", "RunicEffects", ConfigDefaultValues.stoneskinDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19606_, duration, 2), (Entity)attacker);
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19607_, duration, 0), (Entity)attacker);
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19597_, duration, 1), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_02.get(), attacker.m_5720_(), 0.3f, 1.1f);
        }
    }

    public static void postHitRunicTrailblaze(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("trailblazeChance", "RunicEffects", ConfigDefaultValues.trailblazeChance);
        int duration = (int)Config.getFloat("trailblazeDuration", "RunicEffects", ConfigDefaultValues.trailblazeDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, duration, 1), (Entity)attacker);
            attacker.m_20254_(duration / 20);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicGreaterTrailblaze(LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("trailblazeChance", "RunicEffects", ConfigDefaultValues.trailblazeChance);
        int duration = (int)Config.getFloat("trailblazeDuration", "RunicEffects", ConfigDefaultValues.trailblazeDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, duration, 2), (Entity)attacker);
            attacker.m_20254_(duration / 20);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicWeaken(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("weakenChance", "RunicEffects", ConfigDefaultValues.weakenChance);
        int duration = (int)Config.getFloat("weakenDuration", "RunicEffects", ConfigDefaultValues.weakenDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19613_, duration, 0), (Entity)attacker);
            target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, duration, 1), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicGreaterWeaken(LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("weakenChance", "RunicEffects", ConfigDefaultValues.weakenChance);
        int duration = (int)Config.getFloat("weakenDuration", "RunicEffects", ConfigDefaultValues.weakenDuration);
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19613_, duration, 1), (Entity)attacker);
            target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, duration, 2), (Entity)attacker);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
        }
    }

    public static void postHitRunicImbued(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("imbuedChance", "RunicEffects", ConfigDefaultValues.imbuedChance);
        int damage = 6 - stack.m_41773_() / stack.m_41776_() * 100 / 20;
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.f_19802_ = 0;
            target.m_6469_(attacker.m_269291_().m_269425_(), (float)damage);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.2f, 1.8f);
        }
    }

    public static void postHitRunicGreaterImbued(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int hitChance = (int)Config.getFloat("imbuedChance", "RunicEffects", ConfigDefaultValues.imbuedChance);
        int damage = 10 - stack.m_41773_() / stack.m_41776_() * 100 / 10;
        if (attacker.m_217043_().m_188503_(100) <= hitChance) {
            target.f_19802_ = 0;
            target.m_6469_(attacker.m_269291_().m_269425_(), (float)damage);
            attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.2f, 1.8f);
        }
    }

    public static void postHitRunicPinCushion(LivingEntity target, LivingEntity attacker) {
        int stuckArrows = attacker.m_21234_();
        target.m_6469_(attacker.m_269291_().m_269264_(), (float)stuckArrows);
        attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
    }

    public static void postHitRunicGreaterPinCushion(LivingEntity target, LivingEntity attacker) {
        int stuckArrows = attacker.m_21234_();
        target.m_6469_(attacker.m_269291_().m_269264_(), (float)(stuckArrows * 2));
        attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.m_5720_(), 0.1f, 1.8f);
    }

    public static void postHitNetherEcho(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int amp = 0;
        if (HelperMethods.isUniqueTwohanded(stack)) {
            amp = 2;
        }
        target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.ECHO.get(), 20, amp), (Entity)attacker);
    }

    public static void postHitNetherBerserk(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int amp = 2;
        if (HelperMethods.isUniqueTwohanded(stack)) {
            amp = 4;
        }
        if (attacker.m_21230_() < 10) {
            target.m_21153_(target.m_21223_() - (float)amp);
            attacker.m_5634_((float)amp / 2.0f);
        }
    }

    public static void postHitNetherRadiance(LivingEntity target, LivingEntity attacker) {
        if (target.m_21023_(MobEffects.f_19613_)) {
            attacker.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.IMMOLATION.get(), 200, 4), (Entity)attacker);
        }
    }

    public static void postHitNetherOnslaught(LivingEntity target, LivingEntity attacker) {
        if (target.m_21023_(MobEffects.f_19597_) && !attacker.m_21023_(MobEffects.f_19613_)) {
            attacker.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.ONSLAUGHT.get(), 80, 0), (Entity)attacker);
        }
    }

    public static void postHitNetherNullification(LivingEntity user) {
        BlockState state;
        ServerLevel serverWorld;
        BlockState currentState;
        if (!user.m_21023_((MobEffect)EffectRegistry.BATTLE_FATIGUE.get()) && !user.m_9236_().m_5776_() && (currentState = (serverWorld = (ServerLevel)user.m_9236_()).m_8055_(user.m_20183_().m_6630_(4).m_5484_(user.m_6374_(), 3))) == (state = Blocks.f_50016_.m_49966_())) {
            serverWorld.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_01.get(), user.m_5720_(), 0.4f, 0.8f);
            BattleStandardEntity banner = (BattleStandardEntity)((EntityType)EntityRegistry.BATTLESTANDARD.get()).m_262496_(serverWorld, user.m_20183_().m_6630_(4).m_5484_(user.m_6374_(), 3), MobSpawnType.MOB_SUMMONED);
            if (banner != null) {
                banner.m_20334_(0.0, -1.0, 0.0);
                banner.ownerEntity = user;
                banner.decayRate = 3;
                banner.standardType = "nullification";
                banner.m_6593_((Component)Component.m_237110_((String)"entity.simplyswords.battlestandard.name", (Object[])new Object[]{user.m_7755_()}));
            }
            user.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.BATTLE_FATIGUE.get(), 800, 0), (Entity)user);
        }
    }

    public static void postHitRunicEmpty(ItemStack stack, LivingEntity target, LivingEntity attacker) {
    }

    public static void stoppedUsingRunicMomentum(ItemStack stack, LivingEntity user) {
        if (user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
            user.m_20334_(0.0, 0.0, 0.0);
            user.f_19864_ = true;
        }
    }

    public static void usageTickRunicMomentum(ItemStack stack, LivingEntity user, int remainingUseTicks) {
        int skillCooldown = (int)Config.getFloat("momentumCooldown", "RunicEffects", ConfigDefaultValues.momentumCooldown);
        if (user.m_6844_(EquipmentSlot.MAINHAND) == stack && user.m_20096_() && (remainingUseTicks == 12 || remainingUseTicks == 13 && user.m_6844_(EquipmentSlot.MAINHAND) == stack)) {
            user.m_20256_(user.m_20154_().m_82490_(3.0));
            user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
            user.f_19864_ = true;
            if (user instanceof Player) {
                Player player = (Player)user;
                player.m_36335_().m_41524_(stack.m_41720_(), skillCooldown);
            }
        }
    }

    public static void usageTickRunicGreaterMomentum(ItemStack stack, LivingEntity user, int remainingUseTicks) {
        int skillCooldown = (int)Config.getFloat("momentumCooldown", "RunicEffects", ConfigDefaultValues.momentumCooldown);
        if (user.m_6844_(EquipmentSlot.MAINHAND) == stack && user.m_20096_() && (remainingUseTicks == 10 || remainingUseTicks == 13 && user.m_6844_(EquipmentSlot.MAINHAND) == stack)) {
            user.m_20256_(user.m_20154_().m_82490_(3.0));
            user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
            user.f_19864_ = true;
            if (user instanceof Player) {
                Player player = (Player)user;
                player.m_36335_().m_41524_(stack.m_41720_(), skillCooldown);
            }
        }
    }

    public static void inventoryTickRunicUnstable(LivingEntity user) {
        int duration = (int)Config.getFloat("unstableDuration", "RunicEffects", ConfigDefaultValues.unstableDuration);
        int frequency = (int)Config.getFloat("unstableFrequency", "RunicEffects", ConfigDefaultValues.unstableFrequency);
        if (user.f_19797_ % frequency == 0) {
            int random = (int)(Math.random() * 100.0);
            if (random < 10) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration));
            } else if (random < 20) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, duration));
            } else if (random < 30) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration));
            } else if (random < 40) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19609_, duration));
            } else if (random < 50) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19607_, duration));
            } else if (random < 60) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19603_, duration));
            } else if (random < 70) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19598_, duration));
            } else if (random < 80) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19593_, duration));
            } else if (random < 90) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration));
            } else if (random < 95) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19620_, duration));
            } else if (random < 100) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19591_, duration));
            }
        }
    }

    public static void inventoryTickRunicActiveDefence(Level world, LivingEntity user) {
        int frequency;
        Player player;
        if (!world.m_5776_() && user instanceof Player && (player = (Player)user).m_150109_().m_36063_(Items.f_42412_.m_7968_()) && player.f_19797_ % (frequency = (int)Config.getFloat("activeDefenceFrequency", "RunicEffects", ConfigDefaultValues.activeDefenceFrequency)) == 0) {
            int sradius = (int)Config.getFloat("activeDefenceRadius", "RunicEffects", ConfigDefaultValues.activeDefenceRadius);
            int vradius = (int)(Config.getFloat("activeDefenceRadius", "RunicEffects", ConfigDefaultValues.activeDefenceRadius) / 2.0f);
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            AABB box = new AABB(x + (double)sradius, y + (double)vradius, z + (double)sradius, x - (double)sradius, y - (double)vradius, z - (double)sradius);
            for (Entity entity : world.m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)player)) continue;
                int arrowSlot = player.m_150109_().m_36030_(Items.f_42412_.m_7968_());
                ItemStack arrowStack = player.m_150109_().m_8020_(arrowSlot);
                int randomc = (int)(Math.random() * 100.0);
                if (randomc < 15) {
                    arrowStack.m_41774_(1);
                }
                Arrow arrow = new Arrow(EntityType.f_20548_, world);
                arrow.m_20248_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
                arrow.m_5602_((Entity)player);
                arrow.m_20334_(le.m_20185_() - player.m_20185_(), le.m_20186_() - player.m_20186_() - 1.0, le.m_20189_() - player.m_20189_());
                world.m_7967_((Entity)arrow);
                break;
            }
        }
    }

    public static void inventoryTickRunicFrostWard(Level world, LivingEntity user) {
        int frequency = (int)Config.getFloat("frostWardFrequency", "RunicEffects", ConfigDefaultValues.frostWardFrequency);
        int duration = (int)Config.getFloat("frostWardDuration", "RunicEffects", ConfigDefaultValues.frostWardDuration);
        if (user.f_19797_ % frequency == 0) {
            int sradius = (int)Config.getFloat("frostWardRadius", "RunicEffects", ConfigDefaultValues.frostWardRadius);
            int vradius = (int)(Config.getFloat("frostWardRadius", "RunicEffects", ConfigDefaultValues.frostWardRadius) / 2.0f);
            double x = user.m_20185_();
            double y = user.m_20186_();
            double z = user.m_20189_();
            ServerLevel serverWorld = (ServerLevel)world;
            AABB box = new AABB(x + (double)sradius, y + (double)vradius, z + (double)sradius, x - (double)sradius, y - (double)vradius, z - (double)sradius);
            for (Entity entity : serverWorld.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user) || !(le.m_20270_((Entity)user) < (float)sradius)) continue;
                Snowball snowball = new Snowball(EntityType.f_20477_, (Level)serverWorld);
                snowball.m_20248_(user.m_20185_(), user.m_20186_() + 1.5, user.m_20189_());
                snowball.m_5602_((Entity)user);
                le.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration));
                snowball.m_20334_(le.m_20185_() - user.m_20185_(), le.m_20186_() - user.m_20186_() - 1.0, le.m_20189_() - user.m_20189_());
                serverWorld.m_7967_((Entity)snowball);
            }
        }
    }
}

