/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.util.HelperMethods;

public class MagibladeSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public MagibladeSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.f_46443_) {
            if (remainingUseTicks % 5 == 0 && remainingUseTicks < this.m_8105_(stack) - 5 && remainingUseTicks < 10) {
                this.m_5551_(stack, world, user, remainingUseTicks);
            }
            if (remainingUseTicks == this.m_8105_(stack) - 1) {
                world.m_6269_(null, (Entity)user, SoundEvents.f_215772_, user.m_5720_(), 0.6f, 1.4f);
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!user.m_9236_().m_5776_() && user instanceof Player) {
            Player player = (Player)user;
            int skillCooldown = (int)Config.getFloat("magibladeCooldown", "UniqueEffects", ConfigDefaultValues.magibladeCooldown);
            float damageModifier = Config.getFloat("magibladeDamageModifier", "UniqueEffects", ConfigDefaultValues.magibladeDamageModifier);
            float damage = (float)(HelperMethods.getAttackDamage(stack) * (double)damageModifier);
            float distance = Config.getFloat("magibladeSonicDistance", "UniqueEffects", ConfigDefaultValues.magibladeSonicDistance);
            DamageSource damageSource = player.m_269291_().m_269075_(player);
            if (remainingUseTicks < 11) {
                world.m_5594_(null, user.m_20183_(), SoundEvents.f_215771_, user.m_5720_(), 0.8f, 1.1f);
                HelperMethods.spawnDirectionalParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.f_235902_, (Entity)player, 10, distance);
                HelperMethods.damageEntitiesInTrajectory((ServerLevel)world, (Entity)player, distance, damage, damageSource);
                user.m_20256_(user.m_20154_().m_82548_().m_82490_(1.1));
                user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
            }
            player.m_36335_().m_41524_((Item)this, skillCooldown);
        }
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123809_, ParticleTypes.f_123809_, ParticleTypes.f_123783_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.magibladesworditem.tooltip9").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

