/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Block_Rope
extends Block {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.m_61587_((String)"connection", ConnectionStatus.class);
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)4.0, (double)15.99);
    protected static final VoxelShape SIDE_0 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_90 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_180 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0));
    protected static final VoxelShape SIDE_270 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape CORNER_0 = Shapes.m_83110_((VoxelShape)SIDE_180, (VoxelShape)SIDE_90);
    protected static final VoxelShape CORNER_90 = Shapes.m_83110_((VoxelShape)SIDE_180, (VoxelShape)SIDE_270);
    protected static final VoxelShape CORNER_180 = Shapes.m_83110_((VoxelShape)SIDE_270, (VoxelShape)SIDE_0);
    protected static final VoxelShape CORNER_270 = Shapes.m_83110_((VoxelShape)SIDE_0, (VoxelShape)SIDE_90);
    protected static final VoxelShape MIDDLE_90 = Shapes.m_83110_((VoxelShape)SIDE_0, (VoxelShape)SIDE_180);
    protected static final VoxelShape MIDDLE_0 = Shapes.m_83110_((VoxelShape)SIDE_90, (VoxelShape)SIDE_270);
    protected static final VoxelShape BASE_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)3.0, (double)15.99);
    protected static final VoxelShape COLLISION_SIDE_0 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_90 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_180 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)1.0));
    protected static final VoxelShape COLLISION_SIDE_270 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_CORNER_0 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_CORNER_90 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_270);
    protected static final VoxelShape COLLISION_CORNER_180 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_270, (VoxelShape)COLLISION_SIDE_0);
    protected static final VoxelShape COLLISION_CORNER_270 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_MIDDLE_90 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_180);
    protected static final VoxelShape COLLISION_MIDDLE_0 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_90, (VoxelShape)COLLISION_SIDE_270);
    public static final DirectionProperty FACING_TD = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});
    private boolean wasInteractedWith = false;

    public Bridge_Block_Rope(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE))).m_61124_((Property)FACING_TD, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch ((ConnectionStatus)((Object)state.m_61143_(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return CORNER_270;
            }
            case CORNER_NW: {
                return CORNER_180;
            }
            case CORNER_SE: {
                return CORNER_0;
            }
            case CORNER_SW: {
                return CORNER_90;
            }
            case END_E_LEFT: {
                return SIDE_90;
            }
            case END_E_RIGHT: {
                return SIDE_90;
            }
            case END_N_LEFT: {
                return SIDE_270;
            }
            case END_N_RIGHT: {
                return SIDE_270;
            }
            case END_S_LEFT: {
                return SIDE_0;
            }
            case END_S_RIGHT: {
                return SIDE_180;
            }
            case END_W_LEFT: {
                return SIDE_180;
            }
            case END_W_RIGHT: {
                return SIDE_0;
            }
            case MIDDLE_END_E: {
                return MIDDLE_90;
            }
            case MIDDLE_END_N: {
                return MIDDLE_0;
            }
            case MIDDLE_END_S: {
                return MIDDLE_0;
            }
            case MIDDLE_END_W: {
                return MIDDLE_90;
            }
            case MIDDLE_EW: {
                return MIDDLE_0;
            }
            case MIDDLE_NS: {
                return MIDDLE_90;
            }
            case SIDE_E: {
                return SIDE_270;
            }
            case SIDE_N: {
                return SIDE_180;
            }
            case SIDE_S: {
                return SIDE_0;
            }
            case SIDE_W: {
                return SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE;
            }
        }
        return BASE;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction originalDirection = (Direction)state.m_61143_((Property)FACING_TD);
        Direction rotatedDirection = rot.m_55954_(originalDirection);
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.m_61124_((Property)FACING_TD, (Comparable)rotatedDirection);
    }

    public BlockState m_6943_(BlockState state, Mirror mir) {
        Direction originalDirection = (Direction)state.m_61143_((Property)FACING_TD);
        Direction rotatedDirection = mir == Mirror.FRONT_BACK ? originalDirection : originalDirection.m_122424_();
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.m_61124_((Property)FACING_TD, (Comparable)rotatedDirection);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch ((ConnectionStatus)((Object)state.m_61143_(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return COLLISION_CORNER_270;
            }
            case CORNER_NW: {
                return COLLISION_CORNER_180;
            }
            case CORNER_SE: {
                return COLLISION_CORNER_0;
            }
            case CORNER_SW: {
                return COLLISION_CORNER_90;
            }
            case END_E_LEFT: {
                return COLLISION_SIDE_90;
            }
            case END_E_RIGHT: {
                return COLLISION_SIDE_90;
            }
            case END_N_LEFT: {
                return COLLISION_SIDE_270;
            }
            case END_N_RIGHT: {
                return COLLISION_SIDE_270;
            }
            case END_S_LEFT: {
                return COLLISION_SIDE_0;
            }
            case END_S_RIGHT: {
                return COLLISION_SIDE_180;
            }
            case END_W_LEFT: {
                return COLLISION_SIDE_180;
            }
            case END_W_RIGHT: {
                return COLLISION_SIDE_0;
            }
            case MIDDLE_END_E: {
                return COLLISION_MIDDLE_90;
            }
            case MIDDLE_END_N: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_END_S: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_END_W: {
                return COLLISION_MIDDLE_90;
            }
            case MIDDLE_EW: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_NS: {
                return COLLISION_MIDDLE_90;
            }
            case SIDE_E: {
                return COLLISION_SIDE_270;
            }
            case SIDE_N: {
                return COLLISION_SIDE_180;
            }
            case SIDE_S: {
                return COLLISION_SIDE_0;
            }
            case SIDE_W: {
                return COLLISION_SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE_COLLISION;
            }
        }
        return BASE_COLLISION;
    }

    private BlockState StairState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean north = access.m_8055_(pos.m_122012_()).m_60734_() == this;
        boolean east = access.m_8055_(pos.m_122029_()).m_60734_() == this;
        boolean south = access.m_8055_(pos.m_122019_()).m_60734_() == this;
        boolean west = access.m_8055_(pos.m_122024_()).m_60734_() == this;
        ConnectionStatus connection = this.getConnectionStatus(north, east, south, west);
        Direction facingDirection = (Direction)state.m_61143_((Property)FACING_TD);
        return (BlockState)((BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)connection))).m_61124_((Property)FACING_TD, (Comparable)facingDirection);
    }

    private ConnectionStatus getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!(north || south || east || west)) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_END_S;
        }
        if (north && !east && !south && !west) {
            return ConnectionStatus.MIDDLE_END_N;
        }
        if (!north && !east && !south && west) {
            return ConnectionStatus.MIDDLE_END_W;
        }
        if (!north && east && !south && !west) {
            return ConnectionStatus.MIDDLE_END_E;
        }
        if (!north && !east && south && west) {
            return ConnectionStatus.CORNER_SW;
        }
        if (!north && east && south && !west) {
            return ConnectionStatus.CORNER_SE;
        }
        if (north && !east && !south && west) {
            return ConnectionStatus.CORNER_NW;
        }
        if (north && east && !south && !west) {
            return ConnectionStatus.CORNER_NE;
        }
        if (!north && east && south && west) {
            return ConnectionStatus.SIDE_N;
        }
        if (north && !east && south && west) {
            return ConnectionStatus.SIDE_E;
        }
        if (north && east && !south && west) {
            return ConnectionStatus.SIDE_S;
        }
        if (north && east && south && !west) {
            return ConnectionStatus.SIDE_W;
        }
        return ConnectionStatus.BASE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockItem blockItem;
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        ConnectionStatus connection = (ConnectionStatus)((Object)state.m_61143_(CONNECTION));
        if (item == ItemInit.PLIERS.get() || item == Items.f_42574_) {
            ConnectionStatus newConnection = ConnectionStatus.BASE;
            switch (connection) {
                case SIDE_E: 
                case SIDE_N: 
                case SIDE_S: 
                case SIDE_W: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case CORNER_SW: {
                    newConnection = ConnectionStatus.END_N_LEFT;
                    break;
                }
                case END_N_LEFT: {
                    newConnection = ConnectionStatus.END_S_RIGHT;
                    break;
                }
                case END_S_RIGHT: {
                    newConnection = ConnectionStatus.CORNER_NW;
                    break;
                }
                case CORNER_NW: {
                    newConnection = ConnectionStatus.END_S_LEFT;
                    break;
                }
                case END_S_LEFT: {
                    newConnection = ConnectionStatus.END_N_RIGHT;
                    break;
                }
                case END_N_RIGHT: {
                    newConnection = ConnectionStatus.CORNER_NE;
                    break;
                }
                case CORNER_NE: {
                    newConnection = ConnectionStatus.END_E_LEFT;
                    break;
                }
                case END_E_LEFT: {
                    newConnection = ConnectionStatus.END_W_RIGHT;
                    break;
                }
                case END_W_RIGHT: {
                    newConnection = ConnectionStatus.CORNER_SE;
                    break;
                }
                case CORNER_SE: {
                    newConnection = ConnectionStatus.END_W_LEFT;
                    break;
                }
                case END_W_LEFT: {
                    newConnection = ConnectionStatus.END_E_RIGHT;
                    break;
                }
                case END_E_RIGHT: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case BASE_TOGGLED: {
                    newConnection = ConnectionStatus.CORNER_SW;
                    break;
                }
                case BASE: 
                case MIDDLE_EW: 
                case MIDDLE_NS: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
            }
            level.m_46597_(pos, (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)newConnection)));
            this.setWasInteractedWith(true, level, pos);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() instanceof BlockItem && (blockItem = (BlockItem)itemstack.m_41720_()).m_40614_() == this) {
            Direction facing = player.m_6350_();
            Direction blockFacingDirection = facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
            BlockPos placePos = pos.m_121945_(facing);
            if (level.m_8055_(placePos).m_60795_()) {
                level.m_7731_(placePos, (BlockState)this.m_49966_().m_61124_((Property)FACING_TD, (Comparable)blockFacingDirection), 3);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void setWasInteractedWith(boolean interacted, Level level, BlockPos pos) {
        this.wasInteractedWith = interacted;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        this.wasInteractedWith = false;
        if (statetwo.m_61138_((Property)FACING_TD) && statetwo.m_60734_() instanceof Bridge_Block_Rope) {
            Direction facingDirection = (Direction)statetwo.m_61143_((Property)FACING_TD);
            BlockState newState = (BlockState)state.m_61124_((Property)FACING_TD, (Comparable)facingDirection);
            if (!statetwo.m_60713_(newState.m_60734_())) {
                level.m_7731_(pos, this.StairState(newState, (LevelAccessor)level, pos), 2);
            }
        } else {
            Direction currentFacing = (Direction)state.m_61143_((Property)FACING_TD);
            BlockState defaultState = (BlockState)this.m_49966_().m_61124_((Property)FACING_TD, (Comparable)currentFacing);
            level.m_7731_(pos, this.StairState(defaultState, (LevelAccessor)level, pos), 2);
        }
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        if (this.wasInteractedWith) {
            return state;
        }
        ConnectionStatus connection = (ConnectionStatus)((Object)state.m_61143_(CONNECTION));
        if (connection == ConnectionStatus.BASE_TOGGLED || connection == ConnectionStatus.END_N_LEFT || connection == ConnectionStatus.END_N_RIGHT || connection == ConnectionStatus.END_E_LEFT || connection == ConnectionStatus.END_E_RIGHT || connection == ConnectionStatus.END_S_LEFT || connection == ConnectionStatus.END_S_RIGHT || connection == ConnectionStatus.END_W_LEFT || connection == ConnectionStatus.END_W_RIGHT) {
            return state;
        }
        return (BlockState)this.StairState(state, access, pos).m_61124_((Property)FACING_TD, (Comparable)((Direction)state.m_61143_((Property)FACING_TD)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CONNECTION, FACING_TD});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext contx) {
        Direction facingDirection = contx.m_8125_();
        if (facingDirection == Direction.WEST) {
            facingDirection = Direction.EAST;
        } else if (facingDirection == Direction.SOUTH) {
            facingDirection = Direction.NORTH;
        }
        BlockPos pos = contx.m_8083_().m_7495_();
        Level world = contx.m_43725_();
        BlockState stateBelow = world.m_8055_(pos);
        if (stateBelow.m_60734_() instanceof Bridge_Block_Rope) {
            return null;
        }
        return (BlockState)this.StairState(super.m_5573_(contx), (LevelAccessor)contx.m_43725_(), contx.m_8083_()).m_61124_((Property)FACING_TD, (Comparable)facingDirection);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        MIDDLE_NS("middle_ns"),
        MIDDLE_EW("middle_ew"),
        MIDDLE_END_N("middle_end_n"),
        MIDDLE_END_E("middle_end_e"),
        MIDDLE_END_S("middle_end_s"),
        MIDDLE_END_W("middle_end_w"),
        CORNER_NE("corner_ne"),
        CORNER_NW("corner_nw"),
        CORNER_SE("corner_se"),
        CORNER_SW("corner_sw"),
        SIDE_N("side_n"),
        SIDE_E("side_e"),
        SIDE_S("side_s"),
        SIDE_W("side_w"),
        END_N_LEFT("end_n_left"),
        END_N_RIGHT("end_n_right"),
        END_E_LEFT("end_e_left"),
        END_E_RIGHT("end_e_right"),
        END_S_LEFT("end_s_left"),
        END_S_RIGHT("end_s_right"),
        END_W_LEFT("end_w_left"),
        END_W_RIGHT("end_w_right"),
        BASE_TOGGLED("base_toggled");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

