/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.client.ColorSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ECWorldRenderer {
    public static void changeMoonColor(float partialTicks) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        EnhancedCelestials.lunarForecastWorldData((Level)level).ifPresent(data -> {
            ColorSettings lastColorSettings = ((LunarEvent)data.lastLunarEventHolder().m_203334_()).getClientSettings().colorSettings();
            ColorSettings currentColorSettings = ((LunarEvent)data.currentLunarEventHolder().m_203334_()).getClientSettings().colorSettings();
            Vector3f lastGLColor = lastColorSettings.getGLMoonColor();
            Vector3f currentGLColor = currentColorSettings.getGLMoonColor();
            float blend = data.getBlend();
            float r = Mth.m_144920_((float)lastGLColor.x(), (float)currentGLColor.x(), (float)blend);
            float g = Mth.m_144920_((float)lastGLColor.y(), (float)currentGLColor.y(), (float)blend);
            float b = Mth.m_144920_((float)lastGLColor.z(), (float)currentGLColor.z(), (float)blend);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(1.0f - level.m_46722_(partialTicks)));
        });
    }

    public static void bindMoonTexture(int moonTextureId, ResourceLocation moonLocation) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isEmpty()) {
            RenderSystem.setShaderTexture((int)moonTextureId, (ResourceLocation)moonLocation);
            return;
        }
        EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
        RenderSystem.setShaderTexture((int)moonTextureId, (ResourceLocation)data.currentLunarEvent().getClientSettings().moonTextureLocation());
    }

    public static float getMoonSize(float arg0) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isEmpty()) {
            return arg0;
        }
        EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
        return Mth.m_144920_((float)data.lastLunarEvent().getClientSettings().moonSize(), (float)data.currentLunarEvent().getClientSettings().moonSize(), (float)data.getBlend());
    }

    public static void eventLightMap(Vector3f skyVector, float partialTicks) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        EnhancedCelestials.lunarForecastWorldData((Level)level).ifPresent(data -> {
            LunarEvent lastEvent = data.lastLunarEvent();
            LunarEvent currentEvent = data.currentLunarEvent();
            ColorSettings colorSettings = currentEvent.getClientSettings().colorSettings();
            ColorSettings lastColorSettings = lastEvent.getClientSettings().colorSettings();
            Vector3f glSkyLightColor = lastColorSettings.getGLSkyLightColor();
            Vector3f targetColor = new Vector3f(glSkyLightColor.x(), glSkyLightColor.y(), glSkyLightColor.z());
            float skyDarken = (level.m_104805_(1.0f) - 0.2f) / 0.8f;
            float eventBlend = data.getBlend() - skyDarken;
            targetColor.lerp((Vector3fc)colorSettings.getGLSkyLightColor(), eventBlend);
            float skyBlend = 1.0f - skyDarken - level.m_46722_(partialTicks);
            skyVector.lerp((Vector3fc)targetColor, skyBlend);
        });
    }
}

