/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers;

import com.seibel.distanthorizons.api.enums.config.EDhApiMcRenderingFadeMode;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiCancelableEventParam;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.IConfigListener;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.coreapi.util.StringUtil;

public class IgnoredDimensionCsvHandler
extends DhApiBeforeRenderEvent
implements IConfigListener {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static IgnoredDimensionCsvHandler INSTANCE = new IgnoredDimensionCsvHandler();
    private String[] dimensionNames = null;

    private IgnoredDimensionCsvHandler() {
    }

    @Override
    public void onConfigValueSet() {
        String ignoredDimensionCsvString = Config.Client.Advanced.Graphics.Experimental.ignoredDimensionCsv.get();
        if (ignoredDimensionCsvString == null || ignoredDimensionCsvString.isEmpty()) {
            LOGGER.info("Dimension ignoring disabled, DH will render all dimensions.", new Object[0]);
            this.dimensionNames = null;
        } else {
            try {
                this.dimensionNames = ignoredDimensionCsvString.split(",");
                LOGGER.info("DH set to ignore dimensions: [" + StringUtil.join(", ", this.dimensionNames) + "].", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to separate ignored dimensions from CSV string, error: [" + e.getMessage() + "].", e);
                this.dimensionNames = null;
            }
        }
    }

    @Override
    public void beforeRender(DhApiCancelableEventParam<DhApiRenderParam> event) {
        String dimName = ((DhApiRenderParam)event.value).clientLevelWrapper.getDimensionName();
        if (INSTANCE.dimensionNameShouldBeIgnored(dimName)) {
            event.cancelEvent();
            Config.Client.Advanced.Graphics.Fog.enableVanillaFog.setApiValue(true);
            Config.Client.Advanced.Graphics.Quality.vanillaFadeMode.setApiValue(EDhApiMcRenderingFadeMode.NONE);
        } else {
            Config.Client.Advanced.Graphics.Fog.enableVanillaFog.setApiValue(null);
            Config.Client.Advanced.Graphics.Quality.vanillaFadeMode.setApiValue(null);
        }
    }

    public boolean dimensionNameShouldBeIgnored(String dimName) {
        if (this.dimensionNames == null || this.dimensionNames.length == 0) {
            return false;
        }
        for (int i = 0; i < this.dimensionNames.length; ++i) {
            String dimNameToIgnore = this.dimensionNames[i];
            if (!dimName.equalsIgnoreCase(dimNameToIgnore)) continue;
            return true;
        }
        return false;
    }
}

