/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.narrow;

import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.ElementProvider;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import dev.engine_room.flywheel.lib.transform.Affine;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class NarrowDoubleScotchYokeBogeyDisplay
implements BogeyDisplay {
    private final Affine<?> frame;
    private final Affine<?> pistons;
    private final Affine<?>[] wheels;
    private final Affine<?>[] pins;
    private final Affine<?>[] primaryShafts = new Affine[2];
    private final Affine<?>[] secondaryShafts = new Affine[2];

    public NarrowDoubleScotchYokeBogeyDisplay(ElementProvider<?> prov) {
        this.frame = prov.create(CRBlockPartials.NARROW_DOUBLE_SCOTCH_FRAME);
        this.pistons = prov.create(CRBlockPartials.NARROW_DOUBLE_SCOTCH_PISTONS);
        this.wheels = prov.create(CRBlockPartials.NARROW_SCOTCH_WHEELS, 2);
        this.pins = prov.create(CRBlockPartials.NARROW_SCOTCH_WHEEL_PINS, 2);
        prov.create(AllPartialModels.SHAFT, this.primaryShafts, this.secondaryShafts);
    }

    @Override
    public void update(CompoundTag bogeyData, float wheelAngle) {
        for (int i : Iterate.zeroAndOne) {
            ((Affine)((Affine)((Affine)((Affine)this.primaryShafts[i].translate(-0.5, 0.0625, 0.4375 + (double)i * -1.875)).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter();
        }
        for (int i : Iterate.zeroAndOne) {
            ((Affine)((Affine)((Affine)((Affine)this.secondaryShafts[i].translate(-0.5, 0.375, 1.125 + (double)i * -3.25)).center()).rotateTo(Direction.UP, Direction.EAST)).rotateYDegrees(wheelAngle)).uncenter();
        }
        this.frame.translate(0.0f, 0.3125f, 0.0f);
        this.pistons.translate(0.0, 0.875, 0.25 * Math.sin(AngleHelper.rad((double)wheelAngle)));
        for (int side : Iterate.positiveAndNegative) {
            ((Affine)((Affine)this.wheels[(side + 1) / 2].translate(0.0, 0.875, (double)side * 0.75)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.0f, 0.0f);
            ((Affine)((Affine)((Affine)this.pins[(side + 1) / 2].translate(0.0, 0.875, (double)side * 0.75)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.25f, 0.0f)).rotateXDegrees(-wheelAngle);
        }
    }
}

