/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.clientbound;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import umpaz.brewinandchewin.common.capability.RagingCapability;

public record SyncRagingStacksClientboundPacket(int entityId, int stacks) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.writeInt(this.stacks());
    }

    public static SyncRagingStacksClientboundPacket decode(FriendlyByteBuf buf) {
        return new SyncRagingStacksClientboundPacket(buf.readInt(), buf.readInt());
    }

    public static class Handler {
        public static void handle(SyncRagingStacksClientboundPacket packet, Supplier<NetworkEvent.Context> context) {
            if (context.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
                return;
            }
            context.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId());
                if (!(entity instanceof LivingEntity)) {
                    return;
                }
                LivingEntity living = (LivingEntity)entity;
                living.getCapability(RagingCapability.INSTANCE).ifPresent(cap -> cap.setStacks(packet.stacks()));
            });
            context.get().setPacketHandled(true);
        }
    }
}

