/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.SprucePositioned;
import org.thinkingstudio.obsidianui.background.Background;
import org.thinkingstudio.obsidianui.background.EmptyBackground;
import org.thinkingstudio.obsidianui.background.SimpleColorBackground;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.navigation.NavigationUtils;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.widget.SpruceLabelWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.WithBackground;
import org.thinkingstudio.obsidianui.widget.container.SpruceEntryListWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceParentWidget;
import org.thinkingstudio.ryoamiclights.accessor.DynamicLightHandlerHolder;
import org.thinkingstudio.ryoamiclights.config.LightSourceSettingEntry;

public class LightSourceListWidget
extends SpruceEntryListWidget<LightSourceEntry> {
    private static final Background HIGHLIGHT_BACKGROUND = new SimpleColorBackground(128, 128, 128, 24);
    private int lastIndex = 0;

    public LightSourceListWidget(Position position, int width, int height) {
        super(position, width, height, 4, LightSourceEntry.class);
    }

    public int addEntry(DynamicLightHandlerHolder<?> holder) {
        if (holder.ryoamiclights$getSetting() != null) {
            LightSourceEntry entry = LightSourceEntry.create(this, holder);
            int index = this.addEntry(entry);
            if (index % 2 != 0) {
                entry.setBackground(HIGHLIGHT_BACKGROUND);
            }
            return index;
        }
        return -1;
    }

    public void addAll(List<DynamicLightHandlerHolder<?>> types) {
        for (DynamicLightHandlerHolder<?> type : types) {
            this.addEntry(type);
        }
    }

    public void m_142291_(NarrationElementOutput builder) {
        this.children().stream().filter(AbstractSpruceWidget::isMouseHovered).findFirst().ifPresentOrElse(hoveredEntry -> {
            hoveredEntry.m_142291_(builder.m_142047_());
            this.appendPositionNarrations(builder, (SpruceEntryListWidget.Entry)hoveredEntry);
        }, () -> {
            LightSourceEntry focusedEntry = (LightSourceEntry)this.getFocused();
            if (focusedEntry != null) {
                focusedEntry.m_142291_(builder.m_142047_());
                this.appendPositionNarrations(builder, focusedEntry);
            }
        });
        builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
    }

    public static class LightSourceEntry
    extends SpruceEntryListWidget.Entry
    implements SpruceParentWidget<SpruceWidget>,
    WithBackground {
        private final List<SpruceWidget> children = new ArrayList<SpruceWidget>();
        private final LightSourceListWidget parent;
        @Nullable
        private SpruceWidget focused;
        private boolean dragging;
        private Background background = EmptyBackground.EMPTY_BACKGROUND;

        private LightSourceEntry(LightSourceListWidget parent) {
            this.parent = parent;
        }

        public static LightSourceEntry create(LightSourceListWidget parent, DynamicLightHandlerHolder<?> option) {
            LightSourceEntry entry = new LightSourceEntry(parent);
            LightSourceSettingEntry setting = option.ryoamiclights$getSetting();
            entry.children.add((SpruceWidget)new SpruceLabelWidget(Position.of((SprucePositioned)entry, (int)(entry.getWidth() / 2 - 155), (int)7), option.ryoamiclights$getName(), 175));
            entry.children.add(setting.getOption().createWidget(Position.of((SprucePositioned)entry, (int)(entry.getWidth() / 2 + 60), (int)2), 75));
            return entry;
        }

        public int getWidth() {
            return this.parent.getWidth() - this.parent.getBorder().getThickness() * 2;
        }

        public int getHeight() {
            return this.children.stream().mapToInt(SpruceWidget::getHeight).reduce(Integer::max).orElse(0) + 4;
        }

        public List<SpruceWidget> children() {
            return this.children;
        }

        @Nullable
        public SpruceWidget getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable SpruceWidget focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.m_93692_(false);
            }
            this.focused = focused;
        }

        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (!focused) {
                this.setFocused(null);
            }
        }

        public Background getBackground() {
            return this.background;
        }

        public void setBackground(Background background) {
            this.background = background;
        }

        protected boolean onMouseClick(double mouseX, double mouseY, int button) {
            SpruceWidget element;
            Iterator it = this.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!(element = (SpruceWidget)it.next()).m_6375_(mouseX, mouseY, button));
            this.setFocused(element);
            if (button == 0) {
                this.dragging = true;
            }
            return true;
        }

        protected boolean onMouseRelease(double mouseX, double mouseY, int button) {
            this.dragging = false;
            return this.hoveredElement(mouseX, mouseY).filter(element -> element.m_6348_(mouseX, mouseY, button)).isPresent();
        }

        protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.getFocused() != null && this.dragging && button == 0 && this.getFocused().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
            return this.focused != null && this.focused.m_7933_(keyCode, scanCode, modifiers);
        }

        protected boolean onKeyRelease(int keyCode, int scanCode, int modifiers) {
            return this.focused != null && this.focused.m_7920_(keyCode, scanCode, modifiers);
        }

        protected boolean onCharTyped(char chr, int keyCode) {
            return this.focused != null && this.focused.m_5534_(chr, keyCode);
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.forEach(widget -> widget.m_88315_(graphics, mouseX, mouseY, delta));
        }

        protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.background.render(graphics, (SpruceWidget)this, 0, mouseX, mouseY, delta);
        }

        public void m_142291_(NarrationElementOutput builder) {
            SpruceWidget focused = this.getFocused();
            if (focused != null) {
                focused.m_142291_(builder);
            }
        }

        public boolean onNavigation(NavigationDirection direction, boolean tab) {
            if (this.requiresCursor()) {
                return false;
            }
            if (!tab && direction.isVertical()) {
                if (this.m_93696_()) {
                    this.setFocused(null);
                    return false;
                }
                int lastIndex = this.parent.lastIndex;
                if (lastIndex >= this.children.size()) {
                    lastIndex = this.children.size() - 1;
                }
                if (!this.children.get(lastIndex).onNavigation(direction, tab)) {
                    return false;
                }
                this.setFocused(this.children.get(lastIndex));
                return true;
            }
            boolean result = NavigationUtils.tryNavigate((NavigationDirection)direction, (boolean)tab, this.children, (SpruceWidget)this.focused, this::setFocused, (boolean)true);
            if (result) {
                this.m_93692_(true);
                if (direction.isHorizontal() && this.getFocused() != null) {
                    this.parent.lastIndex = this.children.indexOf(this.getFocused());
                }
            }
            return result;
        }
    }
}

