/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivelanterns;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.SimpleAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;
import toni.immersivelanterns.BaseLanternRenderer;
import toni.immersivelanterns.foundation.config.AllConfigs;

class AccessoriesLanternRenderer
extends BaseLanternRenderer
implements SimpleAccessoryRenderer {
    AccessoriesLanternRenderer() {
    }

    public static void register() {
        AccessoriesRendererRegistry.registerRenderer((Item)Items.f_42778_, AccessoriesLanternRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)Items.f_42779_, AccessoriesLanternRenderer::new);
    }

    public static boolean isEquipped(Player player) {
        AccessoriesAPIAccess accessories = (AccessoriesAPIAccess)player;
        AccessoriesCapability capability = accessories.accessoriesCapability();
        if (capability == null) {
            return false;
        }
        return capability.isEquipped((T stack) -> stack.m_41720_() == Items.f_42778_ || stack.m_41720_() == Items.f_42779_);
    }

    public static ItemStack getEquipped(Player player) {
        AccessoriesAPIAccess accessories = (AccessoriesAPIAccess)player;
        AccessoriesCapability capability = accessories.accessoriesCapability();
        if (capability == null) {
            return null;
        }
        List equipped = capability.getEquipped((T stack) -> stack.m_41720_() == Items.f_42778_ || stack.m_41720_() == Items.f_42779_);
        if (equipped == null || equipped.isEmpty()) {
            return null;
        }
        return ((SlotEntryReference)equipped.get(0)).reference().getStack();
    }

    public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (model instanceof PlayerModel) {
                float xOffset;
                PlayerModel playerModel = (PlayerModel)model;
                boolean isWearingArmor = false;
                for (ItemStack armor : player.m_6168_()) {
                    ArmorItem armorItem;
                    Item item = armor.m_41720_();
                    if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40402_() != EquipmentSlot.LEGS && armorItem.m_40402_() != EquipmentSlot.CHEST) continue;
                    isWearingArmor = true;
                    break;
                }
                float lanternTop = 0.6875f;
                float f = xOffset = (Boolean)AllConfigs.client().leftHandedLanterns.get() != false ? 0.1f : 2.0f;
                float zOffset = ((Boolean)AllConfigs.client().backLanterns.get()).booleanValue() ? (isWearingArmor ? -3.1f : -3.0f) : -1.0f;
                Vec3 hipOffset = isWearingArmor ? new Vec3((double)(xOffset + 0.05f), -1.25, (double)(zOffset + 0.05f)) : new Vec3((double)(xOffset - 0.1f), -1.25, (double)(zOffset - 0.1f));
                AccessoryRenderer.transformToModelPart((PoseStack)matrices, (ModelPart)playerModel.f_102810_, (Number)hipOffset.f_82479_, (Number)hipOffset.f_82480_, (Number)hipOffset.f_82481_);
                matrices.m_252880_(0.5f, lanternTop, 0.5f);
                Vector4f localPosition = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                localPosition.mulTranspose((Matrix4fc)matrices.m_85850_().m_252922_());
                Vec3 hipPosition = new Vec3((double)localPosition.x(), (double)localPosition.y(), (double)localPosition.z());
                hipPosition = hipPosition.m_82549_(player.m_20318_(partialTicks));
                Vec3 update = Minecraft.m_91087_().f_91080_ == null && (Boolean)AllConfigs.client().enablePhysics.get() != false ? this.updatePendulum(player, hipPosition, partialTicks) : Vec3.f_82478_;
                double xRot = update.f_82481_;
                xRot += (double)(Math.min(0.0f, playerModel.f_102813_.f_104203_ / 3.0f) - ((Boolean)AllConfigs.client().backLanterns.get() != false ? -0.1f : 0.1f));
                matrices.m_252781_(new Quaternionf().rotationZYX((float)update.f_82479_, 0.0f, (float)(xRot -= (double)playerModel.f_102810_.f_104203_)));
                matrices.m_252880_(-0.5f, -lanternTop, -0.5f);
                BlockState blockstate = Block.m_49814_((Item)stack.m_41720_()).m_49966_();
                Minecraft.m_91087_().m_91289_().m_110912_(blockstate, matrices, multiBufferSource, light, OverlayTexture.f_118083_);
            }
        }
    }

    public <M extends LivingEntity> void align(ItemStack stack, SlotReference reference, EntityModel<M> model, PoseStack matrices) {
    }
}

