/*
 * Decompiled with CFR 0.152.
 */
package net.tct.matmos.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.tct.matmos.MatmosTctMod;
import net.tct.matmos.procedures.InventorySettingsProcedure;
import net.tct.matmos.procedures.MatmosWebProcedure;
import net.tct.matmos.procedures.MusicSettingsProcedure;
import net.tct.matmos.procedures.NetherSettingsProcedure;
import net.tct.matmos.procedures.WindSettingsProcedure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record GUIMatmosSettingsButtonMessage(int buttonID, int x, int y, int z) {
    public GUIMatmosSettingsButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static void buffer(GUIMatmosSettingsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUIMatmosSettingsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> GUIMatmosSettingsButtonMessage.handleButtonAction((Player)context.getSender(), message.buttonID, message.x, message.y, message.z));
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MusicSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            NetherSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            WindSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            InventorySettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            MatmosWebProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MatmosTctMod.addNetworkMessage(GUIMatmosSettingsButtonMessage.class, GUIMatmosSettingsButtonMessage::buffer, GUIMatmosSettingsButtonMessage::new, GUIMatmosSettingsButtonMessage::handler);
    }
}

