/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.scans;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.forgespi.language.IModInfo;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.RequireStencil;
import org.zeith.hammerlib.core.ConfigHL;
import org.zeith.hammerlib.core.scans.base.IAnnotationScanListener;
import org.zeith.hammerlib.core.scans.base.IScanListener;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public class ScanRequireStencil {
    private static final Map<String, FMLModContainer> REQUIRING_STENCIL = new HashMap<String, FMLModContainer>();

    public static IScanListener create() {
        return IAnnotationScanListener.forAnnotation(RequireStencil.class, ElementType.TYPE, ScanRequireStencil::handle);
    }

    private static void handle(ScanDataHelper.ModAwareAnnotationData data) {
        data.getOwnerMod().ifPresent(mc -> REQUIRING_STENCIL.put(data.clazz().getClassName(), (FMLModContainer)mc));
    }

    public static Runnable requestStencil() {
        ConfigHL.ConfigHLClientSide cc = ConfigHL.INSTANCE.get((LogicalSide)LogicalSide.CLIENT).clientSide;
        if (cc.glStencil < 0) {
            return () -> {};
        }
        boolean stencilReq = cc.glStencil > 0;
        for (Map.Entry<String, FMLModContainer> en : REQUIRING_STENCIL.entrySet()) {
            stencilReq = true;
            IModInfo mi = en.getValue().getModInfo();
            HammerLib.LOG.info("Mod's {}({}) class {} is requesting stencils to be enabled.", (Object)mi.getDisplayName(), (Object)mi.getModId(), (Object)en.getKey());
        }
        if (!stencilReq) {
            return () -> {};
        }
        return () -> Minecraft.m_91087_().m_91385_().enableStencil();
    }
}

