/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.js.parsers;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.script.ScriptEngine;
import org.openjdk.nashorn.api.scripting.ClassFilter;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.zeith.hammerlib.core.js.converters.IJsConverter;
import org.zeith.hammerlib.core.js.converters.fb.BindingsFallbackJsConverter;
import org.zeith.hammerlib.core.js.converters.fb.CastingFallbackJsConverter;
import org.zeith.hammerlib.core.js.converters.openjdk.BindingsJ8ScriptObjectMirrorConverter;
import org.zeith.hammerlib.core.js.converters.openjdk.DirectJ8ScriptObjectMirrorConverter;
import org.zeith.hammerlib.core.js.converters.openjdk.DirectJ8ScriptObjectMirrorConverterWithProxy;
import org.zeith.hammerlib.core.js.parsers.IJsParser;

public class OpenJDKParser
implements IJsParser {
    private final NashornScriptEngineFactory engineFactory = new NashornScriptEngineFactory();
    private final ClassFilter classFilter = c -> false;

    @Override
    public List<IJsConverter> getConverters() {
        return Arrays.asList(new CastingFallbackJsConverter(), new DirectJ8ScriptObjectMirrorConverter(), new DirectJ8ScriptObjectMirrorConverterWithProxy(), new BindingsFallbackJsConverter(), new BindingsJ8ScriptObjectMirrorConverter());
    }

    @Override
    public ScriptEngine create() {
        return this.engineFactory.getScriptEngine(new String[]{"-doe", "--language=es6"}, OpenJDKParser.getAppClassLoader(), this.classFilter);
    }

    private static ClassLoader getAppClassLoader() {
        return Objects.requireNonNullElseGet(Thread.currentThread().getContextClassLoader(), NashornScriptEngineFactory.class::getClassLoader);
    }
}

