/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.itf.IntToIntFunction;

public class RenderUtils {
    public static float zLevel = 0.0f;
    private static final Random rand = new Random();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static TextureAtlasSprite getMainSprite(ResourceLocation tex) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(tex);
    }

    public static void renderItemIntoGui(PoseStack pose, ItemStack stack, int x, int y) {
        RenderUtils.renderItemIntoGui(pose, stack, (float)x, (float)y);
    }

    public static void renderItemIntoGui(PoseStack pose, ItemStack stack, float x, float y) {
        boolean flag;
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer ir = mc.m_91291_();
        TextureManager tm = mc.m_91097_();
        BakedModel p_115131_ = ir.m_174264_(stack, null, null, 0);
        tm.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252931_(pose.m_85850_().m_252922_());
        posestack.m_252880_(x, y, 100.0f);
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !p_115131_.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        ir.m_115143_(stack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, p_115131_);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawTexturedModalRect(GuiGraphics pose, float x, float y, float texX, float texY, float width, float height) {
        RenderUtils.drawTexturedModalRect(pose.m_280168_(), x, y, texX, texY, width, height);
    }

    public static void drawTexturedModalRect(PoseStack pose, float x, float y, float texX, float texY, float width, float height) {
        Matrix4f pose4f = pose.m_85850_().m_252922_();
        float n = 0.00390625f;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vb.m_252986_(pose4f, x, y + height, zLevel).m_7421_(texX * n, (texY + height) * n).m_5752_();
        vb.m_252986_(pose4f, x + width, y + height, zLevel).m_7421_((texX + width) * n, (texY + height) * n).m_5752_();
        vb.m_252986_(pose4f, x + width, y, zLevel).m_7421_((texX + width) * n, texY * n).m_5752_();
        vb.m_252986_(pose4f, x, y, zLevel).m_7421_(texX * n, texY * n).m_5752_();
        tess.m_85914_();
    }

    public static void drawFullTexturedModalRect(GuiGraphics pose, float x, float y, float width, float height) {
        Matrix4f pose4f = pose.m_280168_().m_85850_().m_252922_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vb.m_252986_(pose4f, x, y + height, zLevel).m_7421_(0.0f, 1.0f).m_5752_();
        vb.m_252986_(pose4f, x + width, y + height, zLevel).m_7421_(1.0f, 1.0f).m_5752_();
        vb.m_252986_(pose4f, x + width, y, zLevel).m_7421_(1.0f, 0.0f).m_5752_();
        vb.m_252986_(pose4f, x, y, zLevel).m_7421_(0.0f, 0.0f).m_5752_();
        tess.m_85914_();
    }

    public static void drawColoredModalRect(GuiGraphics pose, float x, float y, float width, float height, int rgb) {
        Matrix4f pose4f = pose.m_280168_().m_85850_().m_252922_();
        float r = ColorHelper.getRed(rgb);
        float g = ColorHelper.getGreen(rgb);
        float b = ColorHelper.getBlue(rgb);
        float a = ColorHelper.getAlpha(rgb);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder vb = tess.m_85915_();
        vb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vb.m_252986_(pose4f, x, y + height, zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_252986_(pose4f, x + width, y + height, zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_252986_(pose4f, x + width, y, zLevel).m_85950_(r, g, b, a).m_5752_();
        vb.m_252986_(pose4f, x, y, zLevel).m_85950_(r, g, b, a).m_5752_();
        tess.m_85914_();
    }

    public static void drawTexturedModalRect(PoseStack pose, float xCoord, float yCoord, @Nullable TextureAtlasSprite textureSprite, float widthIn, float heightIn) {
        float maxV;
        float maxU;
        float minV;
        float minU;
        Matrix4f pose4f = pose.m_85850_().m_252922_();
        if (textureSprite == null) {
            minU = 0.0f;
            minV = 0.0f;
            maxU = 1.0f;
            maxV = 1.0f;
        } else {
            minU = textureSprite.m_118409_();
            minV = textureSprite.m_118411_();
            maxU = textureSprite.m_118410_();
            maxV = textureSprite.m_118412_();
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexbuffer = tessellator.m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexbuffer.m_252986_(pose4f, xCoord, yCoord + heightIn, 0.0f).m_7421_(minU, maxV).m_5752_();
        vertexbuffer.m_252986_(pose4f, xCoord + widthIn, yCoord + heightIn, 0.0f).m_7421_(maxU, maxV).m_5752_();
        vertexbuffer.m_252986_(pose4f, xCoord + widthIn, yCoord, 0.0f).m_7421_(maxU, minV).m_5752_();
        vertexbuffer.m_252986_(pose4f, xCoord, yCoord, 0.0f).m_7421_(minU, minV).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawTextRGBA(Font font, GuiGraphics stack, String s, int x, int y, int r, int g, int b, int a) {
        stack.m_280488_(font, s, x, y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void drawTextRGBA(Font font, GuiGraphics stack, Component s, int x, int y, int r, int g, int b, int a) {
        stack.m_280430_(font, s, x, y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void renderColorfulLightRayEffects(MultiBufferSource buffers, PoseStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderColorfulLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void renderLightRayEffects(MultiBufferSource buffers, PoseStack matrix, int rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        RenderSystem.clearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    public static void renderLightRayEffects(MultiBufferSource buffers, PoseStack matrix, int rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        int r = rgba >> 16 & 0xFF;
        int g = rgba >> 8 & 0xFF;
        int b = rgba & 0xFF;
        int a = rgba >> 24 & 0xFF;
        VertexConsumer VertexConsumer2 = buffers.m_6299_(RenderType.m_110502_());
        matrix.m_85836_();
        for (int i = 0; i < rayCount; ++i) {
            matrix.m_252781_(Axis.f_252529_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252403_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252403_.m_252977_(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.m_85850_().m_252922_();
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex2(VertexConsumer2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(VertexConsumer2, mat, f3, f4, r, g, b);
        }
        matrix.m_85849_();
    }

    public static void renderColorfulLightRayEffects(MultiBufferSource buffers, PoseStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        VertexConsumer VertexConsumer2 = buffers.m_6299_(RenderType.m_110502_());
        matrix.m_85836_();
        for (int i = 0; i < rayCount; ++i) {
            int irgba = rgba.applyAsInt(i);
            int r = irgba >> 16 & 0xFF;
            int g = irgba >> 8 & 0xFF;
            int b = irgba & 0xFF;
            int a = irgba >> 24 & 0xFF;
            matrix.m_252781_(Axis.f_252529_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252403_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(rand.nextFloat() * 360.0f));
            matrix.m_252781_(Axis.f_252403_.m_252977_(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.m_85850_().m_252922_();
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex2(VertexConsumer2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(VertexConsumer2, mat, f3, f4, r, g, b);
        }
        matrix.m_85849_();
    }

    private static void vertex01(VertexConsumer c, Matrix4f pose, int r, int g, int b, int a) {
        c.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        c.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
    }

    private static void vertex2(VertexConsumer c, Matrix4f pose, float p_229060_2_, float p_229060_3_, int r, int g, int b) {
        c.m_252986_(pose, -HALF_SQRT_3 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).m_6122_(r, g, b, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer c, Matrix4f pose, float p_229062_2_, float p_229062_3_, int r, int g, int b) {
        c.m_252986_(pose, HALF_SQRT_3 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).m_6122_(r, g, b, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer c, Matrix4f pose, float p_229063_2_, float p_229063_3_, int r, int g, int b) {
        c.m_252986_(pose, 0.0f, p_229063_2_, p_229063_3_).m_6122_(r, g, b, 0).m_5752_();
    }

    public static void drawRect(GuiGraphics pose, int x, int y, int width, int height, int color) {
        ShaderInstance sdr = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderUtils.drawColoredModalRect(pose, x, y, width, height, color);
        RenderSystem.setShader(Cast.constant(sdr));
    }

    public static class PlayerRenderUtil {
        public static void rotateIfSneaking(PoseStack pose, Player player) {
            if (player.m_6144_()) {
                PlayerRenderUtil.applySneakingRotation(pose);
            }
        }

        public static void applySneakingRotation(PoseStack pose) {
            pose.m_252880_(0.0f, 0.2f, 0.0f);
            pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }

        public static void translateToHeadLevel(PoseStack pose, Player player) {
            pose.m_252880_(0.0f, -player.m_20192_(), 0.0f);
            if (player.m_6144_()) {
                pose.m_252880_(0.25f * Mth.m_14031_((float)(player.m_146908_() * (float)Math.PI / 180.0f)), 0.25f * Mth.m_14089_((float)(player.m_146908_() * (float)Math.PI / 180.0f)), 0.0f);
            }
        }

        public static void translateToFace(PoseStack pose) {
            pose.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            pose.m_252880_(0.0f, -4.35f, -1.27f);
        }

        public static void defaultTransforms(PoseStack pose) {
            pose.m_252880_(0.0f, 3.0f, 1.0f);
            pose.m_85841_(0.55f, 0.55f, 0.55f);
        }

        public static void translateToChest(PoseStack pose) {
            pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            pose.m_252880_(0.0f, -3.2f, -0.85f);
        }
    }
}

