/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement.modifier;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import org.violetmoon.zeta.advancement.AdvancementModifier;
import org.violetmoon.zeta.api.IMutableAdvancement;
import org.violetmoon.zeta.module.ZetaModule;

public class FuriousCocktailModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET_AP = new ResourceLocation("nether/all_potions");
    private static final ResourceLocation TARGET_AE = new ResourceLocation("nether/all_effects");
    final BooleanSupplier isPotion;
    final Set<MobEffect> effects;

    public FuriousCocktailModifier(ZetaModule module, BooleanSupplier isPotion, Set<MobEffect> effects) {
        super(module);
        this.isPotion = isPotion;
        this.effects = effects;
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET_AP, (Object)TARGET_AE);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv) {
        Object object;
        if (!this.isPotion.getAsBoolean() && res.equals((Object)TARGET_AP)) {
            return false;
        }
        Criterion crit = adv.getCriterion("all_effects");
        if (crit != null && (object = crit.m_11416_()) instanceof EffectsChangedTrigger.TriggerInstance) {
            EffectsChangedTrigger.TriggerInstance ect = (EffectsChangedTrigger.TriggerInstance)object;
            for (MobEffect e : this.effects) {
                ect.f_26774_.m_56553_(e);
            }
            return true;
        }
        return false;
    }
}

