/*
 * Decompiled with CFR 0.152.
 */
package net.tct.matmos.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.tct.matmos.MatmosTctMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MatmosTctModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MatmosTctMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) {
        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.m_130260_());
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data().serializeNBT());
        }

        public static void handleData(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES).ifPresent(cap -> cap.deserializeNBT(message.data.serializeNBT()));
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public boolean DesertMusic = false;
        public boolean JungleMusic = false;
        public boolean DesertVillageMusic = false;
        public boolean NetherMusic = false;
        public boolean EndMusic = false;
        public boolean BadlandsMusic = false;
        public boolean MusicSettings = true;
        public boolean WindSettings = true;
        public boolean InventorySettings = true;
        public boolean CaveSettings = true;
        public boolean NetherSettings = true;
        public boolean WaterSettings = true;
        public double AmbiantVolume = 1.0;
        public double PlayerVolume = 1.0;
        public double PlayerTimer = 0.0;
        public boolean SetConfigFiles = false;
        public ItemStack MainItem = ItemStack.f_41583_;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("DesertMusic", this.DesertMusic);
            nbt.m_128379_("JungleMusic", this.JungleMusic);
            nbt.m_128379_("DesertVillageMusic", this.DesertVillageMusic);
            nbt.m_128379_("NetherMusic", this.NetherMusic);
            nbt.m_128379_("EndMusic", this.EndMusic);
            nbt.m_128379_("BadlandsMusic", this.BadlandsMusic);
            nbt.m_128379_("MusicSettings", this.MusicSettings);
            nbt.m_128379_("WindSettings", this.WindSettings);
            nbt.m_128379_("InventorySettings", this.InventorySettings);
            nbt.m_128379_("CaveSettings", this.CaveSettings);
            nbt.m_128379_("NetherSettings", this.NetherSettings);
            nbt.m_128379_("WaterSettings", this.WaterSettings);
            nbt.m_128347_("AmbiantVolume", this.AmbiantVolume);
            nbt.m_128347_("PlayerVolume", this.PlayerVolume);
            nbt.m_128347_("PlayerTimer", this.PlayerTimer);
            nbt.m_128379_("SetConfigFiles", this.SetConfigFiles);
            nbt.m_128365_("MainItem", (Tag)this.MainItem.m_41739_(new CompoundTag()));
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.DesertMusic = nbt.m_128471_("DesertMusic");
            this.JungleMusic = nbt.m_128471_("JungleMusic");
            this.DesertVillageMusic = nbt.m_128471_("DesertVillageMusic");
            this.NetherMusic = nbt.m_128471_("NetherMusic");
            this.EndMusic = nbt.m_128471_("EndMusic");
            this.BadlandsMusic = nbt.m_128471_("BadlandsMusic");
            this.MusicSettings = nbt.m_128471_("MusicSettings");
            this.WindSettings = nbt.m_128471_("WindSettings");
            this.InventorySettings = nbt.m_128471_("InventorySettings");
            this.CaveSettings = nbt.m_128471_("CaveSettings");
            this.NetherSettings = nbt.m_128471_("NetherSettings");
            this.WaterSettings = nbt.m_128471_("WaterSettings");
            this.AmbiantVolume = nbt.m_128459_("AmbiantVolume");
            this.PlayerVolume = nbt.m_128459_("PlayerVolume");
            this.PlayerTimer = nbt.m_128459_("PlayerTimer");
            this.SetConfigFiles = nbt.m_128471_("SetConfigFiles");
            this.MainItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("MainItem"));
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("matmos_tct", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES ? this.instance.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.playerVariables.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerVariables.deserializeNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> MatmosTctMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> MatmosTctMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> MatmosTctMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerTickUpdateSyncPlayerVariables(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> {
                    if (capability._syncDirty) {
                        MatmosTctMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability));
                        capability._syncDirty = false;
                    }
                });
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            event.getOriginal().getCapability(PLAYER_VARIABLES).ifPresent(original -> event.getEntity().getCapability(PLAYER_VARIABLES).ifPresent(clone -> {
                clone.DesertMusic = original.DesertMusic;
                clone.JungleMusic = original.JungleMusic;
                clone.DesertVillageMusic = original.DesertVillageMusic;
                clone.NetherMusic = original.NetherMusic;
                clone.EndMusic = original.EndMusic;
                clone.BadlandsMusic = original.BadlandsMusic;
                clone.MusicSettings = original.MusicSettings;
                clone.WindSettings = original.WindSettings;
                clone.InventorySettings = original.InventorySettings;
                clone.CaveSettings = original.CaveSettings;
                clone.NetherSettings = original.NetherSettings;
                clone.WaterSettings = original.WaterSettings;
                clone.AmbiantVolume = original.AmbiantVolume;
                clone.PlayerVolume = original.PlayerVolume;
                clone.SetConfigFiles = original.SetConfigFiles;
                if (!event.isWasDeath()) {
                    clone.PlayerTimer = original.PlayerTimer;
                    clone.MainItem = original.MainItem;
                }
            }));
        }
    }
}

