/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.originsclasses.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CommonUtils {
    public static final String ORIGINS_CLASSES = "OriginsClasses";
    public static final String ENCHANTER = "Enchanter";
    public static final String MODIFY_FOOD_POWERS = "ModifyFoodPowers";
    public static final String POTION_BONUS = "PotionBonus";

    public static CompoundTag getOriginsClassesTag(CompoundTag nbt) {
        if (nbt.m_128425_(ORIGINS_CLASSES, 10)) {
            return nbt.m_128469_(ORIGINS_CLASSES);
        }
        return new CompoundTag();
    }

    public static CompoundTag getOrCreateOriginsClassesTag(CompoundTag nbt) {
        if (nbt.m_128425_(ORIGINS_CLASSES, 10)) {
            return nbt.m_128469_(ORIGINS_CLASSES);
        }
        CompoundTag entry = new CompoundTag();
        nbt.m_128365_(ORIGINS_CLASSES, (Tag)entry);
        return entry;
    }

    public static int rollInt(double d, RandomSource random) {
        int i = (int)d;
        return random.m_188500_() < d - (double)i ? i + 1 : i;
    }

    public static double calcYawDiff(Entity actor, Entity target) {
        float yawTarget;
        for (yawTarget = target.m_146908_(); yawTarget < 0.0f; yawTarget += 360.0f) {
        }
        yawTarget %= 360.0f;
        for (float yawSelf = actor.m_146908_(); yawSelf < 0.0f; yawSelf += 360.0f) {
        }
        return Math.abs(yawTarget - (yawSelf %= 360.0f));
    }

    public static List<BlockPos> lumberjackMultiMineRange(Player player, BlockState state, BlockPos pos) {
        HashSet<BlockPos> affected = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(pos);
        boolean foundOneWithLeaves = false;
        BlockPos.MutableBlockPos pos$mutable = pos.m_122032_();
        BlockPos.MutableBlockPos newPos$mutable = pos.m_122032_();
        while (!queue.isEmpty()) {
            pos$mutable.m_122190_((Vec3i)queue.remove());
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = 0; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 & dy == 0 && dz == 0) continue;
                        newPos$mutable.m_122178_(pos$mutable.m_123341_() + dx, pos$mutable.m_123342_() + dy, pos$mutable.m_123343_() + dz);
                        BlockState newState = player.m_9236_().m_8055_((BlockPos)newPos$mutable);
                        if (newState.m_60713_(state.m_60734_()) && !affected.contains(newPos$mutable)) {
                            BlockPos savedNewPos = newPos$mutable.m_7949_();
                            affected.add(savedNewPos);
                            queue.add(savedNewPos);
                            if (affected.size() <= 255) continue;
                            if (!foundOneWithLeaves) {
                                return new ArrayList<BlockPos>();
                            }
                            return new ArrayList<BlockPos>(affected);
                        }
                        if (!newState.m_204336_(BlockTags.f_13035_) && !(newState.m_60734_() instanceof LeavesBlock) || newState.m_61138_((Property)LeavesBlock.f_54419_) && ((Boolean)newState.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) continue;
                        foundOneWithLeaves = true;
                    }
                }
            }
        }
        if (!foundOneWithLeaves) {
            affected.clear();
        }
        return new ArrayList<BlockPos>(affected);
    }
}

