/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.ice_cube;

import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.ice_cube.goal.IceCubeAttackGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.ice_cube.goal.IceCubeLeapGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IceCubeEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> IS_LEAPING = SynchedEntityData.m_135353_(IceCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean wasOnGround;
    public float targetSquish;
    public float squish;
    public float oSquish;
    private int leapTicks;
    private final MoveControl slimeMoveControl;
    private final MoveControl slidingMoveControl;

    public IceCubeEntity(EntityType<? extends IceCubeEntity> entityType, Level level) {
        super(entityType, level);
        this.m_147244_(true);
        this.f_21364_ = 12;
        this.slimeMoveControl = new IceCubeSlimeMoveControl(this);
        this.slidingMoveControl = new MoveControl((Mob)this);
        this.f_21342_ = this.slimeMoveControl;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, MagmaCube.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Blaze.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new IceCubeLeapGoal(this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new IceCubeAttackGoal((PathfinderMob)this, 1.0, 1.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("wasOnGround", this.wasOnGround);
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.wasOnGround = compoundTag.m_128471_("wasOnGround");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_LEAPING, (Object)false);
    }

    public void setLeaping(boolean leaping) {
        this.f_19804_.m_135381_(IS_LEAPING, (Object)leaping);
        this.leapTicks = leaping ? 15 : 0;
    }

    public boolean getLeaping() {
        return (Boolean)this.f_19804_.m_135370_(IS_LEAPING);
    }

    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.m_8119_();
        if (this.m_20096_() && !this.wasOnGround) {
            for (int j = 0; j < 24; ++j) {
                float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float g = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                float xOffset = Mth.m_14031_((float)f) * 3.0f * 0.5f * g;
                float zOffset = Mth.m_14089_((float)f) * 3.0f * 0.5f * g;
                this.m_9236_().m_7106_(this.getParticleType(), this.m_20185_() + (double)xOffset, this.m_20186_(), this.m_20189_() + (double)zOffset, 0.0, 0.0, 0.0);
                this.targetSquish = -0.5f;
            }
            this.m_5496_(SoundEvents.f_12388_, this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
        } else if (!this.m_20096_() && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.m_20096_();
        this.decreaseSquish();
        this.f_21342_ = this.m_5448_() == null || this.m_20280_((Entity)this.m_5448_()) > 100.0 || Math.abs(this.m_20186_() - this.m_5448_().m_20186_()) / this.m_20275_(this.m_5448_().m_20185_(), this.m_20186_(), this.m_5448_().m_20189_()) > 0.5 ? this.slimeMoveControl : this.slidingMoveControl;
    }

    private void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            // empty if block
        }
        if (!this.m_9236_().m_5776_() && this.getLeaping() && this.leapTicks-- <= 0) {
            this.setLeaping(false);
        }
        super.m_8107_();
        IceSheetBlock iceSheet = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get());
        for (int i = 0; i < 4; ++i) {
            BlockState updatedBlockState;
            int x = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(i % 2 * 2 - 1) * 0.25f)));
            int y = Mth.m_14107_((double)this.m_20186_());
            int z = Mth.m_14107_((double)(this.m_20189_() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f)));
            BlockPos blockPos = new BlockPos(x, y, z);
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            if (!blockState.m_60795_() || (updatedBlockState = iceSheet.m_153940_(blockState, (BlockGetter)this.m_9236_(), blockPos, Direction.DOWN)) == null) continue;
            this.m_9236_().m_46597_(blockPos, updatedBlockState);
            this.m_9236_().m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)updatedBlockState));
        }
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    public void m_6123_(@NotNull Player player) {
        this.dealDamage((LivingEntity)player);
    }

    protected void m_7840_(double $$0, boolean $$1, BlockState $$2, BlockPos $$3) {
    }

    public void m_146917_(int $$0) {
    }

    public int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> entityDataAccessor) {
        this.m_6210_();
        this.m_146922_(this.f_20885_);
        this.f_20883_ = this.f_20885_;
        if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
            this.m_5841_();
        }
        super.m_7350_(entityDataAccessor);
    }

    protected void dealDamage(LivingEntity livingEntity) {
        if (this.m_6084_() && this.m_20280_((Entity)livingEntity) < 2.5 && this.m_142582_((Entity)livingEntity) && livingEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage())) {
            this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19970_((LivingEntity)this, (Entity)livingEntity);
            livingEntity.m_146917_(livingEntity.m_146888_() + 200);
        }
    }

    @ParametersAreNonnullByDefault
    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.15f;
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12386_;
    }

    float getSoundPitch() {
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_11987_;
    }

    public SoundEvent getJumpSound() {
        return SoundEvents.f_12387_;
    }

    public int m_8132_() {
        return 0;
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_175821_;
    }

    private static class IceCubeSlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final IceCubeEntity iceCube;
        private boolean isAggressive;

        public IceCubeSlimeMoveControl(IceCubeEntity iceCube) {
            super((Mob)iceCube);
            this.iceCube = iceCube;
            this.yRot = 180.0f * iceCube.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean isAggressive) {
            this.yRot = yRot;
            this.isAggressive = isAggressive;
        }

        public void setWantedMovement(double speedModifier) {
            this.f_24978_ = speedModifier;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.iceCube.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.iceCube.m_21569_().m_24901_();
                        this.iceCube.m_5496_(this.iceCube.getJumpSound(), this.iceCube.m_6121_(), this.iceCube.getSoundPitch());
                    } else {
                        this.iceCube.f_20900_ = 0.0f;
                        this.iceCube.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }
}

