/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.TemptGoalAccessor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.crafting.Ingredient;

public class HamsterTemptGoal
extends TemptGoal {
    private final HamsterEntity hamster;
    private int recheckTimer = 0;
    private final TargetingConditions TEMPTATION_PREDICATE = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_().m_26888_(this::isTemptedBy);

    public HamsterTemptGoal(HamsterEntity hamster, double speed, boolean canBeScared) {
        super((PathfinderMob)hamster, speed, Ingredient.f_43901_, canBeScared);
        this.hamster = hamster;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean isTemptedBy(LivingEntity entity) {
        return ConfigDataCache.isTamingFood(entity.m_21205_()) || ConfigDataCache.isTamingFood(entity.m_21206_());
    }

    public boolean m_8036_() {
        TemptGoalAccessor accessor = (TemptGoalAccessor)((Object)this);
        if (accessor.getCooldown() > 0) {
            accessor.setCooldown(accessor.getCooldown() - 1);
            return false;
        }
        if (this.hamster.m_21827_() || this.hamster.isCelebratingDiamond()) {
            return false;
        }
        this.f_25925_ = this.hamster.m_9236_().m_45946_(this.TEMPTATION_PREDICATE, (LivingEntity)this.hamster);
        if (this.f_25925_ == null) {
            return false;
        }
        if (this.hamster.m_21824_()) {
            return this.hamster.m_21830_((LivingEntity)this.f_25925_);
        }
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean m_8045_() {
        if (this.hamster.m_21827_() || this.hamster.isCelebratingDiamond()) {
            return false;
        }
        return super.m_8045_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.recheckTimer > 0) {
            --this.recheckTimer;
            return;
        }
        this.recheckTimer = 5;
        if (this.f_25925_ != null) {
            this.hamster.setBegging(this.isTemptedBy((LivingEntity)this.f_25925_));
        } else {
            this.hamster.setBegging(false);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.hamster.setBegging(false);
        this.recheckTimer = 0;
    }
}

