/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BetterEndSpawnPlatformFeature {
    private static final List<StructureProcessor> PROCESSORS = List.of(new DragonEggProcessor());

    public static boolean place(ServerLevel level, BlockPos pos) {
        BlockPos origin = pos.m_7918_(0, -14, 0);
        int numberTimesDragonKilled = 0;
        if (level.m_8586_() != null) {
            numberTimesDragonKilled = ((IDragonFight)level.m_8586_()).betterendisland$numTimesDragonKilled();
        }
        ResourceLocation template = new ResourceLocation("betterendisland", "spawn_platform");
        return BetterEndSpawnPlatformFeature.placeTemplate((ServerLevelAccessor)level, RandomSource.m_216327_(), origin, template, numberTimesDragonKilled);
    }

    private static boolean placeTemplate(ServerLevelAccessor level, RandomSource randomSource, BlockPos centerPos, ResourceLocation id, int numberTimesDragonKilled) {
        Optional templateOptional = level.m_6018_().m_215082_().m_230407_(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos cornerPos = centerPos.m_7918_(-template.m_163801_().m_123341_() / 2, 0, -template.m_163801_().m_123343_() / 2);
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        PROCESSORS.forEach(arg_0 -> ((StructurePlaceSettings)structurePlaceSettings).m_74383_(arg_0));
        structurePlaceSettings.m_74383_((StructureProcessor)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.m_74379_(Rotation.NONE);
        structurePlaceSettings.m_74385_(new BlockPos(3, 0, 3));
        template.m_230328_(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

