/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import net.combatroll.CombatRoll;
import net.combatroll.config.ServerConfig;
import net.combatroll.internals.RollManager;
import net.combatroll.internals.RollingEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public class ClientPlayerEntityMixin
implements RollingEntity {
    private RollManager rollManager = new RollManager();
    @Shadow
    @Final
    protected Minecraft f_108619_;

    @Override
    public RollManager getRollManager() {
        return this.rollManager;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        if (player != null) {
            this.rollManager.tick(player);
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/input/Input;tick(ZF)V", shift=At.Shift.AFTER)})
    private void tickMovement_ModifyInput(CallbackInfo ci) {
        LocalPlayer clientPlayer = (LocalPlayer)this;
        ServerConfig config = CombatRoll.config;
        if (!config.allow_jump_while_rolling && this.rollManager.isRolling()) {
            clientPlayer.f_108618_.f_108572_ = false;
        }
    }

    @Inject(method={"shouldAutoJump"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldAutoJump_HEAD(CallbackInfoReturnable<Boolean> cir) {
        ServerConfig config = CombatRoll.config;
        if (config != null && this.rollManager.isRolling() && !config.allow_auto_jump_while_rolling) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

