/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.item.DragonflyArmorItem;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonflyEntity
extends TamableAnimal
implements GeoEntity {
    @Deprecated(since="4.2.2", forRemoval=true)
    private static final EntityDataAccessor<ItemStack> ARMOR_ITEM = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DragonflyEntity(EntityType<? extends DragonflyEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DragonflyMoveControl(this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        ItemStack legacyArmorStack = (ItemStack)this.f_19804_.m_135370_(ARMOR_ITEM);
        if (!legacyArmorStack.m_41619_() && this.getArmor().m_41619_()) {
            this.setArmor(legacyArmorStack);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22280_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARMOR_ITEM, (Object)ItemStack.f_41583_);
    }

    public static boolean checkDragonflySpawnRules(EntityType<DragonflyEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        int seaLevel = levelAccessor.m_5736_();
        return blockPos.m_123342_() > seaLevel - 10 && blockPos.m_123342_() <= seaLevel + 16 && levelAccessor.m_8055_(blockPos).m_60795_() && levelAccessor.m_45524_(blockPos, 0) > 8;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 6.0f, 2.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false));
        this.f_21345_.m_25352_(4, (Goal)new RandomFlyGoal());
        this.f_21346_.m_25352_(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    public int m_213860_() {
        return this.f_19796_.m_216339_(2, 5);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    public float m_21692_(BlockPos blockPos) {
        return !this.m_21824_() && this.m_9236_().m_204166_(blockPos).m_203565_(Biomes.f_48208_) ? 10.0f : 5.0f;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_21827_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.16, 0.0));
        }
    }

    public void m_7023_(Vec3 speed) {
        if (this.m_21515_()) {
            this.m_19920_(this.m_6113_(), speed);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        }
        this.m_267651_(false);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.m_7008_(true);
        return flyingPathNavigation;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (this.m_21824_()) {
            if (handStack.m_150930_(Items.f_42591_) && this.m_21223_() < this.m_21233_()) {
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                this.m_5634_(2.0f);
                if (!player.m_150110_().f_35937_) {
                    handStack.m_41774_(1);
                }
            } else if (this.m_21830_((LivingEntity)player)) {
                if (!this.m_9236_().m_5776_()) {
                    if (handStack.m_41720_() instanceof DragonflyArmorItem && this.getArmor().m_41619_()) {
                        this.setArmor(handStack.m_41777_());
                        handStack.m_41774_(1);
                        if (!player.m_150110_().f_35937_) {
                            handStack.m_41774_(1);
                        }
                        this.m_5496_(SoundEvents.f_11675_, 0.4f, 1.5f);
                    } else if (player.m_6047_() && !this.getArmor().m_41619_()) {
                        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getArmor().m_41777_()));
                        this.setArmor(ItemStack.f_41583_);
                        this.m_5496_(SoundEvents.f_12019_, 0.2f, 1.0f);
                    } else {
                        this.m_21839_(!this.m_21827_());
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        } else if (handStack.m_150930_(Items.f_42591_)) {
            if (!player.m_150110_().f_35937_) {
                handStack.m_41774_(1);
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.f_19796_.m_188503_(10) == 0 && Services.EVENTS.canTame((Animal)this, player)) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return false;
    }

    public boolean m_35506_() {
        return false;
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dragonfly_sit"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dragonfly_fly"));
        }
        return PlayState.CONTINUE;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void setArmor(ItemStack armorItem) {
        this.m_8061_(EquipmentSlot.CHEST, armorItem);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class DragonflyMoveControl
    extends FlyingMoveControl {
        public DragonflyMoveControl(DragonflyEntity dragonfly) {
            super((Mob)dragonfly, 360, true);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.f_24974_.m_20242_(true);
                double deltaX = this.f_24975_ - this.f_24974_.m_20185_();
                double deltaY = this.f_24976_ - this.f_24974_.m_20186_();
                double deltaZ = this.f_24977_ - this.f_24974_.m_20189_();
                double distanceSqrt = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                if (distanceSqrt < 0.1) {
                    this.f_24974_.m_21567_(this.f_24974_.m_217043_().m_188501_() - 0.5f);
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float f = (float)(Mth.m_14136_((double)deltaZ, (double)deltaX) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 360.0f));
                float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                this.f_24974_.m_7910_(speed);
                double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
                    float f2 = (float)(-(Mth.m_14136_((double)deltaY, (double)horizontalDistance) * 57.2957763671875));
                    this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f2, 20.0f));
                    this.f_24974_.m_21567_(deltaY > 0.0 ? speed : -speed);
                }
            } else {
                this.f_24974_.m_21567_(this.f_24974_.m_217043_().m_188501_() - 0.5f);
                this.f_24974_.m_21564_(0.0f);
            }
        }
    }

    public class RandomFlyGoal
    extends Goal {
        private static final int horizontalRange = 14;
        private static final int verticalRange = 4;

        public RandomFlyGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !DragonflyEntity.this.m_21827_() && DragonflyEntity.this.f_21344_.m_26571_() && DragonflyEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public void m_8056_() {
            Vec3 view = DragonflyEntity.this.m_20252_(0.0f);
            Vec3 randomPos = HoverRandomPos.m_148465_((PathfinderMob)DragonflyEntity.this, (int)14, (int)4, (double)view.f_82479_, (double)view.f_82481_, (float)2.0f, (int)3, (int)1);
            if (randomPos == null) {
                int y = DragonflyEntity.this.m_20069_() ? 2 : -2;
                randomPos = AirAndWaterRandomPos.m_148357_((PathfinderMob)DragonflyEntity.this, (int)14, (int)4, (int)y, (double)view.f_82479_, (double)view.f_82480_, (double)2.0);
            }
            if (randomPos != null) {
                DragonflyEntity.this.f_21344_.m_26536_(DragonflyEntity.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)randomPos), 1), 1.0);
            }
        }
    }
}

