/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.carver;

import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.AbstractCarver;

public class CarverNoiseRange {
    private final float bottom;
    private final float top;
    private final float smoothBottomCutoff;
    private final float smoothTopCutoff;
    private final AbstractCarver carver;
    private static final float SMOOTH_PERCENT = 0.3f;

    public CarverNoiseRange(float bottom, float top, AbstractCarver carver) {
        this.bottom = bottom;
        this.top = top;
        float smoothRangePercent = this.getPercentLength() * 0.3f;
        this.smoothBottomCutoff = NoiseUtils.simplexNoiseOffsetByPercent(bottom, smoothRangePercent);
        this.smoothTopCutoff = NoiseUtils.simplexNoiseNegativeOffsetByPercent(top, smoothRangePercent);
        this.carver = carver;
    }

    public boolean contains(float noiseValue) {
        return this.bottom <= noiseValue && noiseValue < this.top;
    }

    public float getSmoothAmp(float noiseValue) {
        if (this.bottom <= noiseValue && noiseValue <= this.smoothBottomCutoff) {
            return (noiseValue - this.bottom) / (this.smoothBottomCutoff - this.bottom);
        }
        if (this.smoothTopCutoff <= noiseValue && noiseValue < this.top) {
            return (noiseValue - this.top) / (this.smoothTopCutoff - this.top);
        }
        return 1.0f;
    }

    public float getPercentLength() {
        return (this.top == 1.0f ? 1.0f : NoiseUtils.noiseToCDF(this.top)) - (this.bottom == -1.0f ? 0.0f : NoiseUtils.noiseToCDF(this.bottom));
    }

    public AbstractCarver getCarver() {
        return this.carver;
    }

    public String toString() {
        return String.format("[%2.2f, %2.2f] (%2.4f%%) -- smooth cutoffs: [%2.2f, %2.2f]", Float.valueOf(this.bottom), Float.valueOf(this.top), Float.valueOf(this.getPercentLength()), Float.valueOf(this.smoothBottomCutoff), Float.valueOf(this.smoothTopCutoff));
    }
}

