/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;

public class Giant
extends Monster {
    public static EntityType<Giant> createEntityType() {
        return EntityType.Builder.m_20704_(Giant::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.0f, 10.0f).m_20712_("giant");
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    public Giant(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    public int m_213860_() {
        return Random.nextInt((int)40, (int)60);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public float m_274421_() {
        return 4.0f;
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (!this.m_20067_()) {
            SoundEmitter.of((SoundEvent)sound).volume(SoundEmitter.randomized((float)(volume * 1.25f))).pitch(SoundEmitter.randomized((float)(pitch * 0.6f))).source(this.m_5720_()).position(this.m_20182_()).emit(this.m_9236_());
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 8.5f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21527_()) {
            this.m_20254_(8);
        }
        if (TimeHelper.haveSecondsPassed((double)0.5)) {
            EntityHelper.destroyBlocks((Entity)this, (AABB)this.m_20191_().m_82400_(0.6), (blockPos, blockState) -> blockState.m_60734_() instanceof LeavesBlock);
            EntityHelper.destroyBlocks((Entity)this, (AABB)this.m_20191_(), (blockPos, blockState) -> blockState.m_60812_((BlockGetter)this.m_9236_(), blockPos).m_83281_());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GiantMeleeAttackGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    private static class GiantMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Giant giant;
        private int raiseArmTicks;

        public GiantMeleeAttackGoal(Giant giant) {
            super((PathfinderMob)giant, 1.0, true);
            this.giant = giant;
        }

        public void m_8056_() {
            super.m_8056_();
            this.raiseArmTicks = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.giant.m_21561_(false);
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.raiseArmTicks;
            this.giant.m_21561_(this.raiseArmTicks >= 5 && this.m_25565_() < this.m_25566_() / 2);
        }

        protected double m_6639_(LivingEntity target) {
            return 2.0 * (double)this.f_25540_.m_20205_() * (double)this.f_25540_.m_20205_() + (double)target.m_20205_();
        }

        protected void m_6739_(LivingEntity target, double distance) {
            if (distance <= this.m_6639_(target) && this.m_25565_() <= 0) {
                double knockbackMultiplier = 1.0 - target.m_21133_(Attributes.f_22278_);
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                this.f_25540_.m_7327_((Entity)target);
                target.m_246865_(EntityHelper.getDirection2d((Entity)this.giant).mul((Number)-1.0).add((Number)0.0, (Number)1.0, (Number)0.0).mul((Number)knockbackMultiplier).vec3());
            }
        }
    }
}

