/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.events.OnClientTicked;
import com.majruszlibrary.events.OnGuiOverlaysRegistered;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BleedingGui {
    static final List<Particle> PARTICLES = new ArrayList<Particle>();

    public static void addBloodOnScreen(int count) {
        List<Integer> x = BleedingGui.randomizedCoordinates(6);
        List<Integer> y = BleedingGui.randomizedCoordinates(4);
        for (int idx = 0; idx < count; ++idx) {
            PARTICLES.get(x.get(idx) * 4 + y.get(idx)).makeVisible();
        }
    }

    private static List<Integer> randomizedCoordinates(int max) {
        return Random.next(IntStream.iterate(0, i -> i + 1).limit(max).boxed().collect(Collectors.toList()), (int)max);
    }

    private static void render(GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        for (Particle particle : PARTICLES) {
            if (particle.hasFinished()) continue;
            float color = particle.getColor();
            Particle.RenderData renderData = particle.buildRenderData(screenWidth, screenHeight);
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)particle.getAlpha());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)renderData.resource);
            graphics.m_280163_(renderData.resource, renderData.x, renderData.y, 0.0f, 0.0f, renderData.size, renderData.size, renderData.size, renderData.size);
        }
        RenderSystem.disableBlend();
    }

    private static void updateParticles(OnClientTicked data) {
        PARTICLES.forEach(Particle::tick);
    }

    static {
        OnGuiOverlaysRegistered.listen(data -> data.register("bleeding", BleedingGui::render));
        OnClientTicked.listen(BleedingGui::updateParticles);
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 4; ++y) {
                PARTICLES.add(new Particle(x, y));
            }
        }
    }

    static class Particle {
        static final int ASSETS_COUNT = 7;
        static final int GRID_WIDTH = 6;
        static final int GRID_HEIGHT = 4;
        static final int LIFETIME = TimeHelper.toTicks((double)9.0);
        static final List<ResourceLocation> ASSETS = new ArrayList<ResourceLocation>();
        final int x;
        final int y;
        int ticks = LIFETIME;
        int phase = 0;

        public Particle(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void makeVisible() {
            if (!this.hasFinished()) {
                return;
            }
            this.ticks = Random.nextInt((int)0, (int)TimeHelper.toTicks((double)2.0));
            this.phase = Random.nextInt((int)0, (int)6);
        }

        public RenderData buildRenderData(int width, int height) {
            float size = (float)height / 6.0f;
            float x = (float)this.x * size + (this.x >= 3 ? (float)width - 6.0f * size : 0.0f);
            float y = (1.5f * (float)this.y + (this.x % 2 == 0 ? 0.0f : 0.5f)) * size;
            return new RenderData((int)x, (int)y, (int)size, ASSETS.get(this.phase));
        }

        public boolean hasFinished() {
            return this.ticks >= LIFETIME;
        }

        public float getColor() {
            float ratio = (float)this.ticks / (float)LIFETIME;
            return Mth.m_14179_((float)ratio, (float)1.0f, (float)0.6f);
        }

        public float getAlpha() {
            float ratio = (float)this.ticks / (float)LIFETIME;
            return Mth.m_14036_((float)(0.7f * (1.0f - ratio * ratio)), (float)0.0f, (float)0.7f);
        }

        public void tick() {
            if (Side.getMinecraft().m_91104_()) {
                return;
            }
            ++this.ticks;
        }

        static {
            for (int idx = 0; idx < 7; ++idx) {
                ASSETS.add(MajruszsDifficulty.HELPER.getLocation("textures/particle/blood_%d.png".formatted(idx)));
            }
        }

        public record RenderData(int x, int y, int size, ResourceLocation resource) {
        }
    }
}

