/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import umpaz.brewinandchewin.client.integration.appleskin.TipsyAppleSkinCompat;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.registry.BnCEffects;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class BnCHUDOverlays {
    protected static int foodIconsOffset;
    public static final ResourceLocation MOD_ICONS_TEXTURE;
    private static final ResourceLocation NOURISHMENT_ICONS_TEXTURE;
    private static final ResourceLocation NAUSEA_LOCATION;
    private static final ResourceLocation PORTAL_ELEMENT;
    private static final ResourceLocation FOOD_LEVEL_ELEMENT;
    private static float tipsyTransparencyModifier;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new BnCHUDOverlays());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        ForgeGui gui = (ForgeGui)mc.f_91065_;
        if (mc.f_91074_ == null) {
            return;
        }
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)PORTAL_ELEMENT)) {
            if (!mc.f_91074_.m_21023_(MobEffects.f_19604_) && mc.f_91074_.m_21023_((MobEffect)BnCEffects.TIPSY.get())) {
                MobEffectInstance effect = mc.f_91074_.m_21124_((MobEffect)BnCEffects.TIPSY.get());
                float distortionScale = ((Double)mc.f_91066_.m_231924_().m_231551_()).floatValue();
                float tipsyScale = Math.min((float)(1 + effect.m_19564_()) / 10.0f * 0.4f, 0.4f);
                if (distortionScale < 1.0f && tipsyScale > 0.0f) {
                    BnCHUDOverlays.renderTipsyOverlay(event.getGuiGraphics(), (1.0f - distortionScale) * tipsyScale * tipsyTransparencyModifier);
                    float partialTickModifier = event.getPartialTick() * (effect.m_267633_(60) ? -0.006f : 0.007f);
                    tipsyTransparencyModifier = Mth.m_14036_((float)(tipsyTransparencyModifier + partialTickModifier), (float)0.0f, (float)1.0f);
                } else {
                    tipsyTransparencyModifier = 0.0f;
                }
            } else {
                tipsyTransparencyModifier = 0.0f;
            }
        }
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)FOOD_LEVEL_ELEMENT) && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && mc.f_91074_.m_21023_((MobEffect)BnCEffects.INTOXICATION.get())) {
            BnCHUDOverlays.renderIntoxicationOverlay(gui, event);
            event.setCanceled(true);
        }
    }

    public static void renderTipsyOverlay(GuiGraphics guiGraphics, float scalar) {
        int width = guiGraphics.m_280182_();
        int height = guiGraphics.m_280206_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        guiGraphics.m_280246_(scalar, 0.55f * scalar, 0.08f * scalar, 1.0f);
        guiGraphics.m_280398_(NAUSEA_LOCATION, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static void renderIntoxicationOverlay(ForgeGui gui, RenderGuiOverlayEvent.Pre event) {
        if (!((Boolean)BnCConfiguration.INTOXICATION_FOOD_OVERLAY.get()).booleanValue()) {
            return;
        }
        foodIconsOffset = gui.rightHeight;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        int top = minecraft.m_91268_().m_85446_() - foodIconsOffset;
        int right = minecraft.m_91268_().m_85445_() / 2 + 91;
        BnCHUDOverlays.drawIntoxicationOverlay((Player)player, minecraft, event.getGuiGraphics(), right, top);
        if (ModList.get().isLoaded("appleskin")) {
            TipsyAppleSkinCompat.renderAppleSkinFoodWithIntoxication(event, foodIconsOffset);
        }
        gui.rightHeight += 10;
    }

    public static void drawIntoxicationOverlay(Player player, Minecraft minecraft, GuiGraphics graphics, int right, int top) {
        int ticks = minecraft.f_91065_.m_93079_();
        Random rand = new Random();
        rand.setSeed((long)ticks * 312871L);
        RenderSystem.enableBlend();
        ResourceLocation texture = player.m_21023_((MobEffect)ModEffects.NOURISHMENT.get()) ? NOURISHMENT_ICONS_TEXTURE : MOD_ICONS_TEXTURE;
        for (int i = 0; i < 10; ++i) {
            int x = right - i * 8 - 9 + (int)(Mth.m_14089_((float)((float)(ticks + i * 2) * 0.2f)) * 2.0f);
            int y = top + (int)(Mth.m_14031_((float)((float)(ticks + i * 2) * 0.25f)) * 2.0f);
            float effectiveHungerOfBar = (float)player.m_36324_().m_38702_() / 2.0f - (float)i;
            boolean isPlayerHealingWithSaturationAndNourishment = player.m_21023_((MobEffect)ModEffects.NOURISHMENT.get()) && player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && player.m_36325_() && player.m_36324_().m_38702_() >= 18;
            int naturalHealingOffset = isPlayerHealingWithSaturationAndNourishment ? 18 : 0;
            graphics.m_280218_(texture, x, y, 0, 0, 9, 9);
            if (effectiveHungerOfBar >= 1.0f) {
                graphics.m_280218_(texture, x, y, 18 + naturalHealingOffset, 0, 9, 9);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            graphics.m_280218_(texture, x, y, 9 + naturalHealingOffset, 0, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    static {
        MOD_ICONS_TEXTURE = new ResourceLocation("brewinandchewin", "textures/gui/bnc_icons.png");
        NOURISHMENT_ICONS_TEXTURE = new ResourceLocation("farmersdelight", "textures/gui/fd_icons.png");
        NAUSEA_LOCATION = new ResourceLocation("textures/misc/nausea.png");
        PORTAL_ELEMENT = new ResourceLocation("minecraft", "portal");
        FOOD_LEVEL_ELEMENT = new ResourceLocation("minecraft", "food_level");
        tipsyTransparencyModifier = 0.0f;
    }
}

