/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.duck.KPlayer;
import snownee.kiwi.customization.network.SSyncPlaceCountPacket;
import snownee.kiwi.customization.placement.PlaceChoices;
import snownee.kiwi.customization.placement.PlaceMatchResult;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.customization.placement.SlotLink;
import snownee.kiwi.util.Util;

public class PlacementSystem {
    private static final Cache<BlockPlaceContext, PlaceMatchResult> RESULT_CONTEXT = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(100L, TimeUnit.MILLISECONDS).build();

    public static boolean isDebugEnabled(Player player) {
        return player != null && player.m_7500_() && player.m_21206_().m_150930_(Items.f_42464_);
    }

    public static void removeDebugBlocks(Level level, BlockPos start) {
        BlockPos.MutableBlockPos pos = start.m_122032_();
        pos.m_122175_(Direction.UP, 2);
        while (PlacementSystem.isBlockToRemove(level.m_8055_((BlockPos)pos))) {
            level.m_46597_((BlockPos)pos, Blocks.f_50016_.m_49966_());
            pos.m_122173_(Direction.UP);
        }
    }

    private static boolean isBlockToRemove(BlockState blockState) {
        if (blockState.m_60713_(Blocks.f_50752_)) {
            return true;
        }
        String namespace = BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()).m_135827_();
        return CustomizationHooks.getBlockNamespaces().contains(namespace);
    }

    public static BlockState onPlace(BlockItem blockItem, BlockState blockState, BlockPlaceContext context) {
        PlaceMatchResult result;
        PlaceMatchResult result2;
        PlaceChoices choices = null;
        KBlockSettings settings = KBlockSettings.of(blockState.m_60734_());
        if (settings != null) {
            choices = settings.placeChoices;
        }
        if (choices != null && !choices.alter().isEmpty()) {
            for (PlaceChoices.Alter alter : choices.alter()) {
                BlockState altered = alter.alter(blockItem, context);
                if (altered == null) continue;
                return PlacementSystem.onPlace(blockItem, altered, context);
            }
        }
        if (PlaceSlot.hasNoSlots(blockState.m_60734_())) {
            return blockState;
        }
        if (context.m_7078_() && (choices == null || choices.skippable())) {
            return blockState;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        Map<Direction, Collection<PlaceSlot>> neighborSlots = Direction.m_235666_().map($ -> PlaceSlot.find(level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, $)), $.m_122424_())).filter(Predicate.not(Collection::isEmpty)).collect(Collectors.toUnmodifiableMap($ -> ((PlaceSlot)$.iterator().next()).side().m_122424_(), Function.identity()));
        if (neighborSlots.isEmpty()) {
            return blockState;
        }
        boolean debug = PlacementSystem.isDebugEnabled(context.m_43723_());
        ArrayList results = Lists.newArrayList();
        boolean waterLoggable = blockState.m_61138_((Property)BlockStateProperties.f_61362_);
        boolean hasWater = waterLoggable && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false;
        BlockState noWaterBlockState = hasWater ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : blockState;
        PlaceMatchResult originalResult = null;
        for (BlockState possibleState : blockState.m_60734_().m_49965_().m_61056_()) {
            if (waterLoggable && hasWater != (Boolean)possibleState.m_61143_((Property)BlockStateProperties.f_61362_)) continue;
            int bonusInterest = 0;
            if (choices != null && (bonusInterest = choices.test(blockState, possibleState)) == Integer.MIN_VALUE || (result2 = PlacementSystem.getPlaceMatchResultAt(possibleState, neighborSlots, bonusInterest)) == null) continue;
            results.add(result2);
            if (possibleState != noWaterBlockState) continue;
            originalResult = result2;
        }
        if (results.isEmpty()) {
            if (debug && !level.f_46443_) {
                Kiwi.LOGGER.info("No match");
                level.m_46597_((BlockPos)mutable.m_122173_(Direction.UP), Blocks.f_50752_.m_49966_());
            }
            return blockState;
        }
        results.sort(null);
        int resultIndex = 0;
        int maxInterest = ((PlaceMatchResult)results.get(0)).interest();
        if (maxInterest > 0 && results.size() > 1 && (result2 = context.m_43723_()) instanceof KPlayer) {
            KPlayer player = (KPlayer)((Object)result2);
            int i = 1;
            while (i < results.size() && ((PlaceMatchResult)results.get(i)).interest() >= maxInterest) {
                resultIndex = i++;
            }
            if (resultIndex > 0) {
                resultIndex = player.kiwi$getPlaceCount() % (resultIndex + 1);
            }
        }
        PlaceMatchResult placeMatchResult = result = maxInterest == 0 ? originalResult : (PlaceMatchResult)results.get(resultIndex);
        if (result == null) {
            return blockState;
        }
        if (debug && maxInterest > 0 && !level.f_46443_) {
            mutable.m_122159_((Vec3i)pos, Direction.UP);
            Kiwi.LOGGER.info("Interest: %d".formatted(result.interest()));
            results.forEach($ -> {
                if ($ == result) {
                    return;
                }
                level.m_46597_((BlockPos)mutable.m_122173_(Direction.UP), $.blockState());
                Kiwi.LOGGER.info("Alt Interest: %d : %s".formatted($.interest(), $.blockState()));
            });
        }
        BlockState resultState = result.blockState();
        for (SlotLink.MatchResult link : result.links()) {
            resultState = link.onLinkFrom().apply(level, pos, resultState);
        }
        RESULT_CONTEXT.put((Object)context, (Object)result);
        return resultState;
    }

    @Nullable
    public static PlaceMatchResult getPlaceMatchResultAt(BlockState blockState, Map<Direction, Collection<PlaceSlot>> theirSlotsMap, int bonusInterest) {
        int interest = 0;
        ArrayList results = List.of();
        ArrayList offsets = List.of();
        for (Direction side : Util.DIRECTIONS) {
            Collection<PlaceSlot> ourSlots;
            SlotLink.MatchResult result;
            Collection<PlaceSlot> theirSlots = theirSlotsMap.get(side);
            if (theirSlots == null || (result = SlotLink.find(ourSlots = PlaceSlot.find(blockState, side), theirSlots)) == null) continue;
            SlotLink link = result.link();
            interest += link.interest();
            if (results.isEmpty()) {
                results = Lists.newArrayListWithExpectedSize((int)theirSlotsMap.size());
                offsets = Lists.newArrayListWithExpectedSize((int)theirSlotsMap.size());
            }
            results.add((SlotLink.MatchResult)result);
            offsets.add(side.m_122436_());
        }
        if (interest < 0) {
            return null;
        }
        return new PlaceMatchResult(blockState, interest + bonusInterest, results, offsets);
    }

    public static void onBlockPlaced(BlockPlaceContext context) {
        PlaceMatchResult result = (PlaceMatchResult)RESULT_CONTEXT.getIfPresent((Object)context);
        if (result == null) {
            return;
        }
        RESULT_CONTEXT.invalidate((Object)context);
        BlockPos.MutableBlockPos mutable = context.m_8083_().m_122032_();
        for (int i = 0; i < result.links().size(); ++i) {
            BlockPos.MutableBlockPos theirPos = mutable.m_175306_((Vec3i)context.m_8083_(), result.offsets().get(i));
            BlockState theirState = context.m_43725_().m_8055_((BlockPos)theirPos);
            SlotLink.MatchResult link = result.links().get(i);
            theirState = link.onLinkTo().apply(context.m_43725_(), (BlockPos)theirPos, theirState);
            context.m_43725_().m_7731_((BlockPos)theirPos, theirState, 11);
        }
        Player player = context.m_43723_();
        if (player != null) {
            ((KPlayer)player).kiwi$incrementPlaceCount();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SSyncPlaceCountPacket.sync(serverPlayer);
            }
        }
    }

    public static void onBlockRemoved(Level level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (PlaceSlot.hasNoSlots(oldState.m_60734_())) {
            return;
        }
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (Direction direction : Util.DIRECTIONS) {
            SlotLink.MatchResult result;
            BlockState neighborState = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction));
            if (PlaceSlot.hasNoSlots(neighborState.m_60734_()) || (result = SlotLink.find(oldState, neighborState, direction)) == null) continue;
            neighborState = result.onUnlinkTo().apply(level, (BlockPos)mutable, neighborState);
            level.m_46597_((BlockPos)mutable, neighborState);
        }
    }
}

