/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.text;

import com.majruszlibrary.time.TimeHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;

public class TextHelper {
    static final int DEFAULT_SCALE = 2;
    static final TreeMap<Integer, String> ROMAN_LETTERS = new TreeMap();

    public static String toRoman(int number) {
        int nearestKey = ROMAN_LETTERS.floorKey(number);
        return number == nearestKey ? ROMAN_LETTERS.get(number) : ROMAN_LETTERS.get(nearestKey) + TextHelper.toRoman(number - nearestKey);
    }

    public static String toEffectDuration(int ticks) {
        return StringUtil.m_14404_((int)ticks);
    }

    public static String toEffectDuration(double seconds) {
        return TextHelper.toEffectDuration(TimeHelper.toTicks(seconds));
    }

    public static String minPrecision(double number, int scale) {
        if (Math.abs(number - (double)((long)number)) < Math.pow(0.1, scale + 1)) {
            return "%.0f".formatted(number);
        }
        return new BigDecimal(number).setScale(scale, RoundingMode.HALF_EVEN).stripTrailingZeros().toPlainString();
    }

    public static String minPrecision(double number) {
        return TextHelper.minPrecision(number, 2);
    }

    public static String minPrecision(float number, int scale) {
        if ((double)Math.abs(number - (float)((int)number)) < Math.pow(0.1f, scale + 1)) {
            return "%.0f".formatted(Float.valueOf(number));
        }
        return new BigDecimal(number).setScale(scale, RoundingMode.HALF_EVEN).stripTrailingZeros().toPlainString();
    }

    public static String minPrecision(float number) {
        return TextHelper.minPrecision(number, 2);
    }

    public static String signed(float number, int scale) {
        return "%s%s".formatted(number >= 0.0f ? "+" : "", TextHelper.minPrecision(number, scale));
    }

    public static String signed(float number) {
        return TextHelper.signed(number, 2);
    }

    public static String signed(int number) {
        return "%s%d".formatted(number >= 0 ? "+" : "", number);
    }

    public static String signedPercent(float number, int scale) {
        return "%s%%".formatted(TextHelper.signed(number * 100.0f, scale));
    }

    public static String signedPercent(float number) {
        return TextHelper.signedPercent(number, 2);
    }

    public static String signedPercent(int number) {
        return "%s%%".formatted(TextHelper.signed(number * 100));
    }

    public static String percent(float number, int scale) {
        return "%s%%".formatted(TextHelper.minPrecision(number * 100.0f, scale));
    }

    public static String percent(float number) {
        return TextHelper.percent(number, 2);
    }

    public static String percent(int number) {
        return "%d%%".formatted(number * 100);
    }

    public static MutableComponent literal(String text) {
        return Component.m_237113_((String)text);
    }

    public static MutableComponent literal(String text, Object ... arguments) {
        return Component.m_237113_((String)text.formatted(arguments));
    }

    public static MutableComponent translatable(String id, Object ... arguments) {
        return Component.m_237110_((String)id, (Object[])arguments);
    }

    public static MutableComponent empty() {
        return Component.m_237119_();
    }

    public static UnaryOperator<Style> createURL(String url) {
        return style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextHelper.literal(url).m_130940_(ChatFormatting.GRAY)));
    }

    static {
        ROMAN_LETTERS.put(100, "C");
        ROMAN_LETTERS.put(90, "XC");
        ROMAN_LETTERS.put(50, "L");
        ROMAN_LETTERS.put(40, "XL");
        ROMAN_LETTERS.put(10, "X");
        ROMAN_LETTERS.put(9, "IX");
        ROMAN_LETTERS.put(5, "V");
        ROMAN_LETTERS.put(4, "IV");
        ROMAN_LETTERS.put(1, "I");
    }
}

