/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events.base;

import com.majruszlibrary.events.type.ILevelEvent;
import com.majruszlibrary.events.type.IPositionEvent;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class Condition<DataType> {
    final Predicate<DataType> predicate;
    boolean isNegated = false;

    public static <DataType> Condition<DataType> isLogicalServer() {
        return new Condition<Object>(data -> Side.isLogicalServer());
    }

    public static <DataType extends ILevelEvent> Condition<DataType> hasLevel() {
        return new Condition<ILevelEvent>(data -> data.getLevel() != null);
    }

    public static <DataType> Condition<DataType> predicate(Predicate<DataType> predicate) {
        return new Condition<DataType>(predicate);
    }

    public static <DataType> Condition<DataType> predicate(Supplier<Boolean> check) {
        return new Condition<Object>(data -> (Boolean)check.get());
    }

    public static <DataType> Condition<DataType> chance(Supplier<Float> chance) {
        return new Condition<Object>(data -> Random.check(((Float)chance.get()).floatValue()));
    }

    public static <DataType> Condition<DataType> chance(float chance) {
        return Condition.chance(() -> Float.valueOf(chance));
    }

    public static <DataType extends ILevelEvent & IPositionEvent> Condition<DataType> chanceCRD(Supplier<Float> chance, Supplier<Boolean> scaledByCRD) {
        return new Condition<ILevelEvent>(data -> {
            float totalChance = ((Float)chance.get()).floatValue();
            if (((Boolean)scaledByCRD.get()).booleanValue() && data.getLevel() != null) {
                totalChance = (float)((double)totalChance * LevelHelper.getClampedRegionalDifficultyAt(data.getLevel(), AnyPos.from(((IPositionEvent)((Object)data)).getPosition()).block()));
            }
            return Random.check(totalChance);
        });
    }

    public static <DataType extends ILevelEvent & IPositionEvent> Condition<DataType> chanceCRD(float chance, boolean scaledByCRD) {
        return Condition.chanceCRD(() -> Float.valueOf(chance), () -> scaledByCRD);
    }

    public static <DataType> Condition<DataType> cooldown(Supplier<Float> seconds) {
        return new Condition<Object>(data -> TimeHelper.haveSecondsPassed(((Float)seconds.get()).floatValue()));
    }

    public static <DataType> Condition<DataType> cooldown(float seconds) {
        return Condition.cooldown(() -> Float.valueOf(seconds));
    }

    public static <DataType> Condition<DataType> isShiftKeyDown(Function<DataType, Player> player) {
        return new Condition<Object>(data -> player.apply(data) != null && ((Player)player.apply(data)).m_6144_());
    }

    public static <DataType> Condition<DataType> isOnGround(Function<DataType, Entity> entity) {
        return new Condition<Object>(data -> entity.apply(data) != null && ((Entity)entity.apply(data)).m_20096_());
    }

    public static <DataType> Condition<DataType> isCooldownOver(Function<DataType, Player> player, Supplier<? extends Item> item) {
        return new Condition<Object>(data -> player.apply(data) != null && !((Player)player.apply(data)).m_36335_().m_41519_((Item)item.get()));
    }

    public static <DataType extends ILevelEvent> Condition<DataType> isLevel(List<ResourceLocation> levels) {
        return new Condition<ILevelEvent>(data -> levels.contains(data.getLevel().m_46472_().m_135782_()));
    }

    public Condition<DataType> negate() {
        this.isNegated = !this.isNegated;
        return this;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public boolean check(DataType data) {
        return this.isNegated ^ this.predicate.test(data);
    }

    private Condition(Predicate<DataType> predicate) {
        this.predicate = predicate;
    }
}

