/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.shape.Circle;
import org.popcraft.chunky.shape.Diamond;
import org.popcraft.chunky.shape.Ellipse;
import org.popcraft.chunky.shape.Hexagon;
import org.popcraft.chunky.shape.Pentagon;
import org.popcraft.chunky.shape.Rectangle;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.Square;
import org.popcraft.chunky.shape.Star;
import org.popcraft.chunky.shape.Triangle;
import org.popcraft.chunky.util.Translator;

public final class ShapeFactory {
    private static final Map<String, BiFunction<Selection, Boolean, Shape>> custom = new HashMap<String, BiFunction<Selection, Boolean, Shape>>();

    private ShapeFactory() {
    }

    public static Shape getShape(Selection selection) {
        return ShapeFactory.getShape(selection, true);
    }

    public static Shape getShape(Selection selection, boolean chunkAligned) {
        return switch (selection.shape()) {
            case "circle" -> new Circle(selection, chunkAligned);
            case "diamond" -> new Diamond(selection, chunkAligned);
            case "ellipse", "oval" -> new Ellipse(selection, chunkAligned);
            case "hexagon" -> new Hexagon(selection, chunkAligned);
            case "pentagon" -> new Pentagon(selection, chunkAligned);
            case "rectangle" -> new Rectangle(selection, chunkAligned);
            case "star" -> new Star(selection, chunkAligned);
            case "triangle" -> new Triangle(selection, chunkAligned);
            default -> custom.getOrDefault(selection.shape(), Square::new).apply(selection, chunkAligned);
        };
    }

    public static void registerCustom(String name, BiFunction<Selection, Boolean, Shape> shapeFunction) {
        custom.put(name, shapeFunction);
        Translator.addCustomTranslation("shape_%s".formatted(name), name);
    }

    public static Set<String> getCustomTypes() {
        return custom.keySet();
    }
}

