/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.utils;

import com.zigythebird.playeranimatorapi.data.PlayerPart;
import com.zigythebird.playeranimatorapi.mixin.CameraAccessor;
import com.zigythebird.playeranimatorapi.modifier.AbstractCameraModifier;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.Iterator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CameraUtils {
    @Nullable
    public static Vec3f computeCameraAngles(GameRenderer renderer, Camera camera, double partialTicks) {
        CustomModifierLayer layer = PlayerAnimations.getModifierLayer((AbstractClientPlayer)Minecraft.m_91087_().f_91074_);
        if (layer != null && layer.isActive() && layer.cameraAnimEnabled) {
            Vec3f rot = new Vec3f(camera.m_90589_(), camera.m_90590_(), 0.0f).scale((float)Math.PI / 180);
            Iterator<AbstractCameraModifier> iterator = layer.cameraModifiers.iterator();
            while (iterator.hasNext()) {
                AbstractCameraModifier object;
                AbstractCameraModifier modifier = object = iterator.next();
                rot = modifier.get3DCameraTransform(renderer, camera, TransformType.ROTATION, (float)partialTicks, rot);
            }
            return rot.scale(57.29578f);
        }
        return null;
    }

    public static void computeCameraLocation(GameRenderer renderer, @NotNull Camera camera, double partialTicks) {
        CustomModifierLayer layer = PlayerAnimations.getModifierLayer((AbstractClientPlayer)Minecraft.m_91087_().f_91074_);
        if (layer != null && layer.isActive() && layer.cameraAnimEnabled) {
            Iterator<AbstractCameraModifier> iterator = layer.cameraModifiers.iterator();
            while (iterator.hasNext()) {
                AbstractCameraModifier object;
                AbstractCameraModifier modifier = object = iterator.next();
                Vec3f transform = modifier.get3DCameraTransform(renderer, camera, TransformType.POSITION, (float)partialTicks, Vec3f.ZERO).scale(0.0625f);
                Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
                Vec3f angles = CameraUtils.computeCameraAngles(renderer, camera, partialTicks);
                if (angles == null) {
                    return;
                }
                PlayerPart head = layer.data.parts().head;
                if (!head.yaw || !head.pitch) {
                    float xRot = head.yaw ? ((Float)angles.getX()).floatValue() : camera.m_90589_();
                    float yRot = head.pitch ? ((Float)angles.getY()).floatValue() : camera.m_90590_();
                    angles = new Vec3f(xRot, yRot, ((Float)angles.getZ()).floatValue());
                }
                rotation.rotationYXZ(-((Float)angles.getY()).floatValue() * ((float)Math.PI / 180), ((Float)angles.getX()).floatValue() * ((float)Math.PI / 180), ((Float)angles.getZ()).floatValue() * ((float)Math.PI / 180));
                Vector3f forwards = new Vector3f(0.0f, 0.0f, 1.0f);
                Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
                Vector3f left = new Vector3f(1.0f, 0.0f, 0.0f);
                forwards.set(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)rotation);
                up.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)rotation);
                left.set(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)rotation);
                double d = (double)forwards.x() * (double)((Float)transform.getX()).floatValue() + (double)up.x() * (double)((Float)transform.getY()).floatValue() + (double)left.x() * (double)((Float)transform.getZ()).floatValue();
                double e = (double)forwards.y() * (double)((Float)transform.getX()).floatValue() + (double)up.y() * (double)((Float)transform.getY()).floatValue() + (double)left.y() * (double)((Float)transform.getZ()).floatValue();
                double f = (double)forwards.z() * (double)((Float)transform.getX()).floatValue() + (double)up.z() * (double)((Float)transform.getY()).floatValue() + (double)left.z() * (double)((Float)transform.getZ()).floatValue();
                ((CameraAccessor)camera).callSetPosition(camera.m_90583_().f_82481_ + f, camera.m_90583_().f_82480_ - e, camera.m_90583_().f_82479_ - d);
            }
        }
    }
}

