/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.mixin;

import com.zigythebird.playeranimatorapi.azure.AnimatablePlayerLayer;
import com.zigythebird.playeranimatorapi.mixin.AnimatableManagerAccessor_azureOnly;
import com.zigythebird.playeranimatorapi.mixin.AnimationControllerAccessor_azureOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.core.animatable.model.CoreGeoModel;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationProcessor;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.EasingType;
import mod.azure.azurelib.core.keyframe.AnimationPoint;
import mod.azure.azurelib.core.keyframe.BoneAnimationQueue;
import mod.azure.azurelib.core.state.BoneSnapshot;
import mod.azure.azurelib.core.utils.Interpolations;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnimationProcessor.class})
public abstract class AnimationProcessorMixin_azureOnly<T extends GeoAnimatable> {
    @Shadow(remap=false)
    public boolean reloadAnimations;
    @Shadow(remap=false)
    @Final
    private Map<String, CoreGeoBone> bones;

    @Shadow(remap=false)
    protected abstract Map<String, BoneSnapshot> updateBoneSnapshots(Map<String, BoneSnapshot> var1);

    @Shadow(remap=false)
    protected abstract void resetBoneTransformationMarkers();

    @Shadow(remap=false)
    public abstract Collection<CoreGeoBone> getRegisteredBones();

    @Inject(method={"tickAnimation"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void inject(T animatable, CoreGeoModel<T> model, AnimatableManager<T> animatableManager, double animTime, AnimationState<T> event, boolean crashWhenCantFindBone, CallbackInfo ci) {
        if (animatable instanceof AnimatablePlayerLayer) {
            BoneSnapshot initialSnapshot;
            BoneSnapshot saveSnapshot;
            ArrayList<CoreGeoBone> disabledBones = new ArrayList<CoreGeoBone>();
            Map<String, BoneSnapshot> boneSnapshots = this.updateBoneSnapshots(animatableManager.getBoneSnapshotCollection());
            Iterator var9 = animatableManager.getAnimationControllers().values().iterator();
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "body", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "head", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "torso", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "right_arm", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "left_arm", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "rightItem", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "leftItem", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "right_leg", model);
            AnimationProcessorMixin_azureOnly.addDisabled(disabledBones, "left_leg", model);
            while (var9.hasNext()) {
                AnimationController controller = (AnimationController)var9.next();
                if (this.reloadAnimations) {
                    controller.forceAnimationReset();
                    controller.getBoneAnimationQueues().clear();
                }
                ((AnimationControllerAccessor_azureOnly)controller).setIsJustStarting(animatableManager.isFirstTick());
                event.withController(controller);
                controller.process(model, event, this.bones, boneSnapshots, animTime, crashWhenCantFindBone);
                for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues().values()) {
                    CoreGeoBone bone = boneAnimation.bone();
                    if (disabledBones.contains(bone)) continue;
                    saveSnapshot = boneSnapshots.get(bone.getName());
                    initialSnapshot = bone.getInitialSnapshot();
                    AnimationPoint rotXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                    AnimationPoint rotYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                    AnimationPoint rotZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                    AnimationPoint posXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                    AnimationPoint posYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                    AnimationPoint posZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                    AnimationPoint scaleXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                    AnimationPoint scaleYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                    AnimationPoint scaleZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                    EasingType easingType = ((AnimationControllerAccessor_azureOnly)controller).getOverrideEasingTypeFunction().apply(animatable);
                    if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
                        bone.setRotX((float)EasingType.lerpWithOverride((AnimationPoint)rotXPoint, (EasingType)easingType) + initialSnapshot.getRotX());
                        bone.setRotY((float)EasingType.lerpWithOverride((AnimationPoint)rotYPoint, (EasingType)easingType) + initialSnapshot.getRotY());
                        bone.setRotZ((float)EasingType.lerpWithOverride((AnimationPoint)rotZPoint, (EasingType)easingType) + initialSnapshot.getRotZ());
                        saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                        saveSnapshot.startRotAnim();
                        bone.markRotationAsChanged();
                    }
                    if (posXPoint != null && posYPoint != null && posZPoint != null) {
                        bone.setPosX((float)EasingType.lerpWithOverride((AnimationPoint)posXPoint, (EasingType)easingType));
                        bone.setPosY((float)EasingType.lerpWithOverride((AnimationPoint)posYPoint, (EasingType)easingType));
                        bone.setPosZ((float)EasingType.lerpWithOverride((AnimationPoint)posZPoint, (EasingType)easingType));
                        saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                        saveSnapshot.startPosAnim();
                        bone.markPositionAsChanged();
                    }
                    if (scaleXPoint == null || scaleYPoint == null || scaleZPoint == null) continue;
                    bone.setScaleX((float)EasingType.lerpWithOverride((AnimationPoint)scaleXPoint, (EasingType)easingType));
                    bone.setScaleY((float)EasingType.lerpWithOverride((AnimationPoint)scaleYPoint, (EasingType)easingType));
                    bone.setScaleZ((float)EasingType.lerpWithOverride((AnimationPoint)scaleZPoint, (EasingType)easingType));
                    saveSnapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
                    saveSnapshot.startScaleAnim();
                    bone.markScaleAsChanged();
                }
            }
            this.reloadAnimations = false;
            double resetTickLength = animatable.getBoneResetTime();
            for (CoreGeoBone bone : this.getRegisteredBones()) {
                double percentageReset;
                if (disabledBones.contains(bone)) continue;
                if (!bone.hasRotationChanged()) {
                    initialSnapshot = bone.getInitialSnapshot();
                    saveSnapshot = boneSnapshots.get(bone.getName());
                    if (saveSnapshot.isRotAnimInProgress()) {
                        saveSnapshot.stopRotAnim(animTime);
                    }
                    percentageReset = Math.min((animTime - saveSnapshot.getLastResetRotationTick()) / resetTickLength, 1.0);
                    bone.setRotX((float)Interpolations.lerp((double)saveSnapshot.getRotX(), (double)initialSnapshot.getRotX(), (double)percentageReset));
                    bone.setRotY((float)Interpolations.lerp((double)saveSnapshot.getRotY(), (double)initialSnapshot.getRotY(), (double)percentageReset));
                    bone.setRotZ((float)Interpolations.lerp((double)saveSnapshot.getRotZ(), (double)initialSnapshot.getRotZ(), (double)percentageReset));
                    if (percentageReset >= 1.0) {
                        saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    }
                }
                if (!bone.hasPositionChanged()) {
                    initialSnapshot = bone.getInitialSnapshot();
                    saveSnapshot = boneSnapshots.get(bone.getName());
                    if (saveSnapshot.isPosAnimInProgress()) {
                        saveSnapshot.stopPosAnim(animTime);
                    }
                    percentageReset = Math.min((animTime - saveSnapshot.getLastResetPositionTick()) / resetTickLength, 1.0);
                    bone.setPosX((float)Interpolations.lerp((double)saveSnapshot.getOffsetX(), (double)initialSnapshot.getOffsetX(), (double)percentageReset));
                    bone.setPosY((float)Interpolations.lerp((double)saveSnapshot.getOffsetY(), (double)initialSnapshot.getOffsetY(), (double)percentageReset));
                    bone.setPosZ((float)Interpolations.lerp((double)saveSnapshot.getOffsetZ(), (double)initialSnapshot.getOffsetZ(), (double)percentageReset));
                    if (percentageReset >= 1.0) {
                        saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    }
                }
                if (bone.hasScaleChanged()) continue;
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isScaleAnimInProgress()) {
                    saveSnapshot.stopScaleAnim(animTime);
                }
                percentageReset = Math.min((animTime - saveSnapshot.getLastResetScaleTick()) / resetTickLength, 1.0);
                bone.setScaleX((float)Interpolations.lerp((double)saveSnapshot.getScaleX(), (double)initialSnapshot.getScaleX(), (double)percentageReset));
                bone.setScaleY((float)Interpolations.lerp((double)saveSnapshot.getScaleY(), (double)initialSnapshot.getScaleY(), (double)percentageReset));
                bone.setScaleZ((float)Interpolations.lerp((double)saveSnapshot.getScaleZ(), (double)initialSnapshot.getScaleZ(), (double)percentageReset));
                if (!(percentageReset >= 1.0)) continue;
                saveSnapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            }
            this.resetBoneTransformationMarkers();
            ((AnimatableManagerAccessor_azureOnly)animatableManager).callFinishFirstTick();
            ci.cancel();
        }
    }

    @Unique
    private static void addDisabled(List<CoreGeoBone> list, String bone, CoreGeoModel model) {
        if (model.getBone(bone).isPresent()) {
            list.add((CoreGeoBone)model.getBone(bone).get());
        }
    }
}

