/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.spells_gone_wrong.common.spell;

import com.kekecreations.spells_gone_wrong.core.config.SpellsGoneWrongCommonConfig;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.creeper_head.CreeperHeadProjectile;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ShotgunCreeperSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("spells_gone_wrong", "shotgun_creeper");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(10).setCooldownSeconds(2.0).build();

    public ShotgunCreeperSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 0;
        this.castTime = 2;
        this.baseManaCost = 40;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.projectile_count", (Object[])new Object[]{this.getCount()}));
    }

    private int getCount() {
        return 3;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    private float getDamage(int spellLevel) {
        return 1.0f + (float)spellLevel;
    }

    public boolean isEnabled() {
        return (Boolean)SpellsGoneWrongCommonConfig.SHOTGUN_CREEPER_SPELL.get();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float speed = 0.8f;
        float speed2 = 0.8f;
        float damage = this.getDamage(spellLevel);
        CreeperHeadProjectile head = new CreeperHeadProjectile(entity, level, speed, damage);
        CreeperHeadProjectile head2 = new CreeperHeadProjectile(entity, level, speed2, damage);
        CreeperHeadProjectile head3 = new CreeperHeadProjectile(entity, level, speed2, damage);
        Vec3 spawn = entity.m_146892_().m_82549_(entity.m_20156_());
        head.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
        if (entity.m_6350_() == Direction.NORTH || entity.m_6350_() == Direction.SOUTH) {
            head2.m_7678_(spawn.f_82479_ + 0.8, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
            head3.m_7678_(spawn.f_82479_ - 0.8, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
        }
        if (entity.m_6350_() == Direction.WEST || entity.m_6350_() == Direction.EAST) {
            head2.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ + 0.8, entity.m_146908_() + 180.0f, entity.m_146909_());
            head3.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ - 0.8, entity.m_146908_() + 180.0f, entity.m_146909_());
        }
        level.m_7967_((Entity)head);
        level.m_7967_((Entity)head2);
        level.m_7967_((Entity)head3);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }
}

