/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.forge.service;

import dev.obscuria.fragmentum.forge.registry.ForgeRegistrar;
import dev.obscuria.fragmentum.forge.service.ForgeClientService;
import dev.obscuria.fragmentum.forge.service.ForgeConfigService;
import dev.obscuria.fragmentum.forge.service.ForgeFactoryService;
import dev.obscuria.fragmentum.forge.service.ForgeNetworkService;
import dev.obscuria.fragmentum.forge.service.ForgeServerService;
import dev.obscuria.fragmentum.registry.Registrar;
import dev.obscuria.fragmentum.service.ClientService;
import dev.obscuria.fragmentum.service.ConfigService;
import dev.obscuria.fragmentum.service.FactoryService;
import dev.obscuria.fragmentum.service.FragmentumServices;
import dev.obscuria.fragmentum.service.NetworkService;
import dev.obscuria.fragmentum.service.ServerService;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.locating.IModFile;

public final class ForgeServices
implements FragmentumServices {
    @Override
    public Optional<Path> resolveRootPath(String modId) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow();
        IModFile modFile = container.getModInfo().getOwningFile().getFile();
        return Optional.of(modFile.getSecureJar().getRootPath());
    }

    @Override
    public Registrar registrar(String modId) {
        return new ForgeRegistrar(modId);
    }

    @Override
    public FactoryService factory() {
        return ForgeFactoryService.INSTANCE;
    }

    @Override
    public NetworkService network() {
        return ForgeNetworkService.INSTANCE;
    }

    @Override
    public ServerService server() {
        return ForgeServerService.INSTANCE;
    }

    @Override
    public ClientService client() {
        return ForgeClientService.INSTANCE;
    }

    @Override
    public ConfigService config() {
        return ForgeConfigService.INSTANCE;
    }
}

