/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolOutcome
extends ETFScreenOldCompat {
    private final boolean didSucceed;
    private final NativeImage skin;

    protected ETFConfigScreenSkinToolOutcome(Screen parent, boolean success, NativeImage skin) {
        super("config.entity_texture_features.player_skin_editor.print_skin.result", parent, false);
        this.didSucceed = success;
        this.skin = skin;
    }

    public static boolean uploadSkin(boolean skinType) {
        try {
            if ("127.0.0.1".equals(InetAddress.getLocalHost().getHostAddress())) {
                return false;
            }
            String auth = Minecraft.m_91087_().m_91094_().m_92547_();
            Path skinPath = Path.of(ETF.getConfigDirectory().toFile().getParent(), "ETF_player_skin_printout.png");
            String boundary = UUID.randomUUID().toString();
            byte[] fileBytes = Files.readAllBytes(skinPath);
            String bodyStart = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"variant\"\r\n\r\n" + (skinType ? "classic" : "slim") + "\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"file\"; filename=\"skin.png\"\r\nContent-Type: image/png\r\n\r\n";
            String bodyEnd = "\r\n--" + boundary + "--\r\n";
            byte[] requestBody = ETFConfigScreenSkinToolOutcome.concat(bodyStart.getBytes(), fileBytes, bodyEnd.getBytes());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.minecraftservices.com/minecraft/profile/skins")).header("Authorization", "Bearer " + auth).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            return response.statusCode() == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static byte[] concat(byte[] ... parts) {
        int len = 0;
        for (byte[] p : parts) {
            len += p.length;
        }
        byte[] out = new byte[len];
        int pos = 0;
        for (byte[] p : parts) {
            System.arraycopy(p, 0, out, pos, p.length);
            pos += p.length;
        }
        return out;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.55), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20, CommonComponents.f_130655_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)));
        if (this.didSucceed) {
            this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.15), (int)((double)this.f_96544_ * 0.6), (int)((double)this.f_96543_ * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.open"), button -> {
                try {
                    assert (ETF.getConfigDirectory() != null);
                    Path outputDirectory = Path.of(ETF.getConfigDirectory().toFile().getParent(), new String[0]);
                    Util.m_137581_().m_137644_(outputDirectory.toFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.15), (int)((double)this.f_96544_ * 0.4), (int)((double)this.f_96543_ * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin"), button -> {
                boolean changeSuccess;
                String skinTypeData;
                PlayerInfo playerListEntry;
                if (Minecraft.m_91087_().f_91074_ == null) {
                    return;
                }
                boolean skinType = true;
                if (Minecraft.m_91087_().m_91403_() != null && (playerListEntry = Minecraft.m_91087_().m_91403_().m_104949_(Minecraft.m_91087_().f_91074_.m_20148_())) != null && (skinTypeData = ((MinecraftProfileTexture)Minecraft.m_91087_().m_91109_().m_118815_(playerListEntry.m_105312_()).get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model")) != null) {
                    skinType = !"slim".equals(skinTypeData);
                }
                button.m_93666_(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin_v2." + ((changeSuccess = ETFConfigScreenSkinToolOutcome.uploadSkin(skinType)) ? "success" : "fail")));
                if (changeSuccess) {
                    HttpTexture skinfile = (HttpTexture)Minecraft.m_91087_().m_91109_().f_118807_.m_174786_(Minecraft.m_91087_().f_91074_.m_108560_(), null);
                    try {
                        assert (skinfile.f_117994_ != null);
                        this.skin.m_85056_(skinfile.f_117994_);
                    }
                    catch (IOException e) {
                        ETFUtils2.logError(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin.success_local_fail").getString(), true);
                    }
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(Minecraft.m_91087_().f_91074_.m_20148_());
                    }
                } else {
                    ETFUtils2.logError("Failed to change in-game skin correctly, you might need to restart to see all the uploaded changes in-game", true);
                }
                button.f_93623_ = false;
            }));
        }
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        String[] strings = ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result." + (this.didSucceed ? "success" : "fail")).getString().split("\n");
        ArrayList<Component> lines = new ArrayList<Component>();
        for (String str : strings) {
            lines.add(Component.m_130674_((String)str.strip()));
        }
        int i = 0;
        for (Component txt : lines) {
            context.m_280364_(this.f_96547_, txt.m_7532_(), (int)((double)this.f_96543_ * 0.5), (int)((double)this.f_96544_ * 0.3) + i, 0xFFFFFF);
            i += txt.getString().isBlank() ? 5 : 10;
        }
    }
}

