/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;

public class StorageBlockItem
extends BlockItemBase
implements ITintableBlockItem {
    public static final String ACCENT_COLOR_TAG = "accentColor";
    public static final String MAIN_COLOR_TAG = "mainColor";
    private static final String SHOWS_TIER_TAG = "showsTier";

    public StorageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static Optional<CompoundTag> getEntityWrapperTagFromStack(ItemStack barrelStack) {
        return NBTHelper.getCompound((ItemStack)barrelStack, (String)"BlockEntityTag").flatMap(tag -> NBTHelper.getCompound((CompoundTag)tag, (String)"storageWrapper"));
    }

    public static Optional<Integer> getMainColorFromStack(ItemStack barrelStack) {
        return StorageBlockItem.getEntityWrapperTagFromStack(barrelStack).map(tag -> NBTHelper.getInt((CompoundTag)tag, (String)MAIN_COLOR_TAG)).orElse(NBTHelper.getInt((ItemStack)barrelStack, (String)MAIN_COLOR_TAG));
    }

    public static Optional<Integer> getAccentColorFromStack(ItemStack barrelStack) {
        return StorageBlockItem.getEntityWrapperTagFromStack(barrelStack).map(tag -> NBTHelper.getInt((CompoundTag)tag, (String)ACCENT_COLOR_TAG)).orElse(NBTHelper.getInt((ItemStack)barrelStack, (String)ACCENT_COLOR_TAG));
    }

    public static void setNumberOfInventorySlots(ItemStack storageStack, int numberOfInventorySlots) {
        NBTHelper.setInteger((ItemStack)storageStack, (String)"numberOfInventorySlots", (int)numberOfInventorySlots);
    }

    public static void setNumberOfUpgradeSlots(ItemStack storageStack, int numberOfUpgradeSlots) {
        NBTHelper.setInteger((ItemStack)storageStack, (String)"numberOfUpgradeSlots", (int)numberOfUpgradeSlots);
    }

    public static int getNumberOfInventorySlots(ItemStack storageStack) {
        return NBTHelper.getInt((ItemStack)storageStack, (String)"numberOfInventorySlots").orElse(0);
    }

    public static int getNumberOfUpgradeSlots(ItemStack storageStack) {
        return NBTHelper.getInt((ItemStack)storageStack, (String)"numberOfUpgradeSlots").orElse(0);
    }

    public static boolean isLocked(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"locked").orElse(false);
    }

    public static void setLocked(ItemStack stack, boolean locked) {
        if (locked) {
            stack.m_41784_().m_128379_("locked", true);
        } else {
            NBTHelper.removeTag((ItemStack)stack, (String)"locked");
        }
    }

    @Override
    public void setMainColor(ItemStack storageStack, int mainColor) {
        storageStack.m_41784_().m_128405_(MAIN_COLOR_TAG, mainColor);
    }

    @Override
    public Optional<Integer> getMainColor(ItemStack storageStack) {
        return StorageBlockItem.getMainColorFromStack(storageStack);
    }

    @Override
    public void setAccentColor(ItemStack storageStack, int accentColor) {
        storageStack.m_41784_().m_128405_(ACCENT_COLOR_TAG, accentColor);
    }

    @Override
    public void removeMainColor(ItemStack stack) {
        NBTHelper.removeTag((ItemStack)stack, (String)MAIN_COLOR_TAG);
    }

    @Override
    public void removeAccentColor(ItemStack stack) {
        NBTHelper.removeTag((ItemStack)stack, (String)ACCENT_COLOR_TAG);
    }

    @Override
    public Optional<Integer> getAccentColor(ItemStack stack) {
        return StorageBlockItem.getAccentColorFromStack(stack);
    }

    public static boolean showsTier(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)SHOWS_TIER_TAG).orElse(true);
    }

    public static void setShowsTier(ItemStack stack, boolean showsTier) {
        if (showsTier) {
            NBTHelper.removeTag((ItemStack)stack, (String)SHOWS_TIER_TAG);
        } else {
            stack.m_41784_().m_128379_(SHOWS_TIER_TAG, false);
        }
    }

    public static Optional<UUID> getContentsUuid(ItemStack stack) {
        return NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid");
    }
}

