/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Locale;
import net.merchantpug.apugli.entity.CustomProjectile;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ActiveCooldownPowerFactory;
import net.merchantpug.apugli.util.TextureUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public interface CustomProjectilePowerFactory<P>
extends ActiveCooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ActiveCooldownPowerFactory.getSerializableData().add("texture_location", SerializableDataTypes.IDENTIFIER, null).add("texture_url", SerializableDataTypes.STRING, null).add("count", SerializableDataTypes.INT, (Object)1).add("interval", SerializableDataTypes.INT, (Object)0).add("start_delay", SerializableDataTypes.INT, (Object)0).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("tag", SerializableDataTypes.NBT, null).add("entity_action_before_firing", Services.ACTION.entityDataType(), null).add("bientity_action_after_firing", Services.ACTION.biEntityDataType(), null).add("block_action_on_hit", Services.ACTION.blockDataType(), null).add("bientity_action_on_miss", Services.ACTION.biEntityDataType(), null).add("bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("owner_target_bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("allow_conditional_cancelling", SerializableDataTypes.BOOLEAN, (Object)false).add("block_action_cancels_miss_action", SerializableDataTypes.BOOLEAN, (Object)false).add("block_condition", Services.CONDITION.blockDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("owner_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("tick_bientity_action", Services.ACTION.biEntityDataType(), null);
    }

    default public void cacheTextureUrl(ResourceLocation powerId, P power) {
        ResourceLocation urlTextureLocation = this.getUrlTextureIdentifier(powerId);
        TextureUtil.getCache().add((Triple<ResourceLocation, String, ResourceLocation>)Triple.of((Object)urlTextureLocation, (Object)this.getDataFromPower(power).getString("texture_url"), (Object)this.getDataFromPower(power).getId("texture_location")));
    }

    default public ResourceLocation getUrlTextureIdentifier(ResourceLocation powerId) {
        return new ResourceLocation("apugli", this.getPowerClassString().toLowerCase(Locale.ROOT) + "/" + powerId.m_135827_() + "/" + powerId.m_135815_());
    }

    default public String getPowerClassString() {
        return "CustomProjectilePower";
    }

    public ResourceLocation getPowerId(P var1);

    public long getLastUseTime(P var1, Entity var2);

    public int getShotProjectiles(P var1, Entity var2);

    public boolean isFiringProjectiles(P var1, Entity var2);

    public boolean finishedStartDelay(P var1, Entity var2);

    public void setShotProjectiles(P var1, Entity var2, int var3);

    public void setFiringProjectiles(P var1, Entity var2, boolean var3);

    public void setFinishedStartDelay(P var1, Entity var2, boolean var3);

    default public void tick(P power, LivingEntity entity) {
        if (this.isFiringProjectiles(power, (Entity)entity)) {
            SerializableData.Instance data = this.getDataFromPower(power);
            if (!this.finishedStartDelay(power, (Entity)entity) && data.getInt("start_delay") == 0) {
                this.setFinishedStartDelay(power, (Entity)entity, true);
            }
            if (!this.finishedStartDelay(power, (Entity)entity) && (entity.m_20193_().m_46467_() - this.getLastUseTime(power, (Entity)entity)) % (long)data.getInt("start_delay") == 0L) {
                this.setFinishedStartDelay(power, (Entity)entity, true);
                this.setShotProjectiles(power, (Entity)entity, this.getShotProjectiles(power, (Entity)entity) + 1);
                if (this.getShotProjectiles(power, (Entity)entity) <= data.getInt("count")) {
                    this.playSound(data, entity);
                    if (!entity.m_9236_().f_46443_) {
                        this.fireProjectile(power, data, entity);
                    }
                } else {
                    this.reset(power, entity);
                }
            } else if (data.getInt("interval") == 0 && this.finishedStartDelay(power, (Entity)entity)) {
                this.playSound(data, entity);
                if (!entity.m_9236_().f_46443_) {
                    while (this.getShotProjectiles(power, (Entity)entity) < data.getInt("count")) {
                        this.fireProjectile(power, data, entity);
                        this.setShotProjectiles(power, (Entity)entity, this.getShotProjectiles(power, (Entity)entity) + 1);
                    }
                }
                this.reset(power, entity);
            } else if (this.finishedStartDelay(power, (Entity)entity) && (entity.m_20193_().m_46467_() - this.getLastUseTime(power, (Entity)entity)) % (long)data.getInt("interval") == 0L) {
                this.setShotProjectiles(power, (Entity)entity, this.getShotProjectiles(power, (Entity)entity) + 1);
                if (this.getShotProjectiles(power, (Entity)entity) <= data.getInt("count")) {
                    this.playSound(data, entity);
                    if (!entity.m_9236_().f_46443_) {
                        this.fireProjectile(power, data, entity);
                    }
                } else {
                    this.reset(power, entity);
                }
            }
        }
    }

    default public void playSound(SerializableData.Instance data, LivingEntity entity) {
        if (data.get("sound") != null) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)data.get("sound"), SoundSource.NEUTRAL, 0.5f, 0.4f / (entity.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
    }

    default public void reset(P power, LivingEntity entity) {
        this.setShotProjectiles(power, (Entity)entity, 0);
        this.setFinishedStartDelay(power, (Entity)entity, false);
        this.setFiringProjectiles(power, (Entity)entity, false);
    }

    default public void fireProjectile(P power, SerializableData.Instance data, LivingEntity entity) {
        Services.ACTION.executeEntity(data, "entity_action_before_firing", (Entity)entity);
        if (data.getBoolean("allow_conditional_cancelling") && !Services.POWER.isActive(power, entity)) {
            this.setFiringProjectiles(power, (Entity)entity, false);
            return;
        }
        float yaw = entity.m_146908_();
        float pitch = entity.m_146909_();
        Vec3 rotationVec = entity.m_20154_();
        Vec3 spawnPos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0).m_82549_(rotationVec);
        CustomProjectile projectile = new CustomProjectile(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), entity, entity.m_9236_());
        projectile.setEntityId(this.getPowerId(power));
        projectile.m_5602_((Entity)entity);
        projectile.m_37251_((Entity)entity, pitch, yaw, 0.0f, data.getFloat("speed"), data.getFloat("divergence") * 0.075f);
        projectile.setImpactBlockAction(data, "block_action_on_hit");
        projectile.setBlockActionCancelsMissAction(data.getBoolean("block_action_cancels_miss_action"));
        projectile.setMissBiEntityAction(data, "bientity_action_on_miss");
        projectile.setImpactBiEntityAction(data, "bientity_action_on_hit");
        projectile.setOwnerImpactBiEntityAction(data, "owner_target_bientity_action_on_hit");
        projectile.setTextureLocation(data.getId("texture_location"));
        projectile.setUrlLocation(this.getUrlTextureIdentifier(this.getPowerId(power)));
        projectile.setBlockCondition(data, "block_condition");
        projectile.setOwnerBiEntityCondition(data, "owner_bientity_condition");
        projectile.setBiEntityCondition(data, "bientity_condition");
        projectile.setTickBiEntityAction(data, "tick_bientity_action");
        if (data.get("tag") != null) {
            CompoundTag mergedTag = projectile.m_20240_(new CompoundTag());
            mergedTag.m_128391_((CompoundTag)data.get("tag"));
            projectile.m_20258_(mergedTag);
        }
        entity.m_9236_().m_7967_((Entity)projectile);
        Services.ACTION.executeBiEntity(data, "bientity_action_after_firing", (Entity)entity, (Entity)projectile);
    }
}

