/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;

public class ProjectileActionOverTimePower
extends Power {
    private final int interval;
    private final Consumer<Tuple<Entity, Entity>> biEntityAction;
    private final Consumer<Tuple<Entity, Entity>> risingAction;
    private final Consumer<Tuple<Entity, Entity>> fallingAction;
    private final Predicate<Tuple<Entity, Entity>> biEntityCondition;
    private boolean wasActive = false;
    private final Map<Projectile, Integer> initialTicks = new HashMap<Projectile, Integer>();

    public ProjectileActionOverTimePower(PowerType<?> type, LivingEntity entity, int interval, Consumer<Tuple<Entity, Entity>> biEntityAction, Consumer<Tuple<Entity, Entity>> risingAction, Consumer<Tuple<Entity, Entity>> fallingAction, Predicate<Tuple<Entity, Entity>> biEntityCondition) {
        super(type, entity);
        this.interval = interval;
        this.biEntityAction = biEntityAction;
        this.risingAction = risingAction;
        this.fallingAction = fallingAction;
        this.biEntityCondition = biEntityCondition;
    }

    public boolean doesApply(Projectile projectile) {
        return this.biEntityCondition == null || this.biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)projectile));
    }

    public void projectileTick(Projectile projectile) {
        if (!this.initialTicks.containsKey(projectile)) {
            this.initialTicks.put(projectile, projectile.f_19797_ % this.interval);
        }
        if (this.entity.f_19797_ % this.interval == this.initialTicks.get(projectile)) {
            if (this.isActive() && this.doesApply(projectile)) {
                if (!this.wasActive && this.risingAction != null) {
                    this.risingAction.accept((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)projectile));
                }
                if (this.biEntityAction != null) {
                    this.biEntityAction.accept((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)projectile));
                }
                this.wasActive = true;
            } else {
                if (this.wasActive && this.fallingAction != null) {
                    this.fallingAction.accept((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)projectile));
                }
                this.wasActive = false;
            }
        }
        if (projectile.m_213877_()) {
            this.initialTicks.remove(projectile);
        }
    }

    public static class Factory
    extends SimplePowerFactory<ProjectileActionOverTimePower> {
        public Factory() {
            super("projectile_action_over_time", new SerializableData().add("interval", SerializableDataTypes.INT, (Object)20).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("rising_action", Services.ACTION.biEntityDataType(), null).add("falling_action", Services.ACTION.biEntityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null), data -> (type, entity) -> new ProjectileActionOverTimePower((PowerType<?>)type, (LivingEntity)entity, data.getInt("interval"), Services.ACTION.biEntityConsumer((SerializableData.Instance)data, "bientity_action"), Services.ACTION.biEntityConsumer((SerializableData.Instance)data, "rising_action"), Services.ACTION.biEntityConsumer((SerializableData.Instance)data, "falling_action"), Services.CONDITION.biEntityPredicate((SerializableData.Instance)data, "bientity_condition")));
            this.allowCondition();
        }

        @Override
        public Class<ProjectileActionOverTimePower> getPowerClass() {
            return ProjectileActionOverTimePower.class;
        }
    }
}

