/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PreventEntitySelectionPower
extends Power {
    public final Predicate<Entity> entityCondition;
    public final Predicate<Tuple<Entity, Entity>> biEntityCondition;

    public PreventEntitySelectionPower(PowerType<?> type, LivingEntity entity, Predicate<Entity> entityCondition, Predicate<Tuple<Entity, Entity>> biEntityCondition) {
        super(type, entity);
        this.entityCondition = entityCondition;
        this.biEntityCondition = biEntityCondition;
    }

    public boolean shouldPrevent(Entity entity) {
        return !(this.entityCondition != null && !this.entityCondition.test(entity) || this.biEntityCondition != null && !this.biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)entity)));
    }

    public static class Factory
    extends SimplePowerFactory<PreventEntitySelectionPower> {
        public Factory() {
            super("prevent_entity_selection", new SerializableData().add("entity_condition", Services.CONDITION.entityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null), data -> (type, entity) -> new PreventEntitySelectionPower((PowerType<?>)type, (LivingEntity)entity, Services.CONDITION.entityPredicate((SerializableData.Instance)data, "entity_condition"), Services.CONDITION.biEntityPredicate((SerializableData.Instance)data, "bientity_condition")));
            this.allowCondition();
        }

        @Override
        public Class<PreventEntitySelectionPower> getPowerClass() {
            return PreventEntitySelectionPower.class;
        }
    }
}

