/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.power.TextureOrUrlPower;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class EntityTextureOverlayPower
extends TextureOrUrlPower {
    private final boolean showFirstPerson;
    private final boolean usesRenderingPowers;
    private final boolean renderPlayerOuterLayer;
    private final boolean renderOriginalModel;

    public EntityTextureOverlayPower(PowerType<?> type, LivingEntity entity, ResourceLocation textureLocation, String textureUrl, boolean showFirstPerson, boolean usesRenderingPowers, boolean renderPlayerOuterLayer, boolean renderOriginalModel) {
        super(type, entity, textureLocation, textureUrl);
        this.showFirstPerson = showFirstPerson;
        this.usesRenderingPowers = usesRenderingPowers;
        this.renderPlayerOuterLayer = renderPlayerOuterLayer;
        this.renderOriginalModel = renderOriginalModel;
    }

    @Override
    public String getPowerClassString() {
        return "EntityTextureOverlayPower";
    }

    public boolean shouldShowFirstPerson() {
        return this.showFirstPerson;
    }

    public boolean shouldUseRenderingPowers() {
        return this.usesRenderingPowers;
    }

    public boolean shouldRenderPlayerOuterLayer() {
        return this.renderPlayerOuterLayer;
    }

    public boolean shouldRenderOriginalModel() {
        return this.renderOriginalModel;
    }

    public boolean shouldRenderOriginalModelClient() {
        return this.renderOriginalModel || !TextureUtilClient.getUrls().containsKey(this.getUrlTextureIdentifier()) && this.textureLocation == null;
    }

    public static class Factory
    extends SimplePowerFactory<EntityTextureOverlayPower> {
        public Factory() {
            super("entity_texture_overlay", TextureOrUrlPower.getSerializableData().add("show_first_person", SerializableDataTypes.BOOLEAN, (Object)false).add("use_rendering_powers", SerializableDataTypes.BOOLEAN, (Object)false).add("render_player_outer_layer", SerializableDataTypes.BOOLEAN, (Object)true).add("render_original_model", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, player) -> new EntityTextureOverlayPower((PowerType<?>)type, (LivingEntity)player, data.getId("texture_location"), data.getString("texture_url"), data.getBoolean("show_first_person"), data.getBoolean("use_rendering_powers"), data.getBoolean("render_player_outer_layer"), data.getBoolean("render_original_model")));
            this.allowCondition();
        }

        @Override
        public Class<EntityTextureOverlayPower> getPowerClass() {
            return EntityTextureOverlayPower.class;
        }
    }
}

