/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AllowAnvilEnchantPower
extends Power {
    @Nullable
    private final Predicate<Tuple<Level, ItemStack>> itemCondition;
    private final List<Enchantment> enchantments = new ArrayList<Enchantment>();
    public Comparison comparison;
    public int compareTo;

    public AllowAnvilEnchantPower(PowerType<?> type, LivingEntity entity, @Nullable Predicate<Tuple<Level, ItemStack>> itemCondition, Comparison comparison, int compareTo) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.compareTo = compareTo;
        this.comparison = comparison;
    }

    public boolean doesApply(Enchantment enchantment, ItemStack stackA, ItemStack stackB) {
        if (!this.enchantments.contains(enchantment)) {
            return false;
        }
        if (this.itemCondition != null && !this.itemCondition.test((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)stackA))) {
            return false;
        }
        Map map = EnchantmentHelper.m_44831_((ItemStack)stackB);
        if (!map.containsKey(enchantment)) {
            return false;
        }
        return this.comparison.compare((double)((Integer)map.get(enchantment)).intValue(), (double)this.compareTo);
    }

    public static class Factory
    extends SimplePowerFactory<AllowAnvilEnchantPower> {
        public Factory() {
            super("allow_anvil_enchant", new SerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT, null).add("enchantments", SerializableDataType.list((SerializableDataType)SerializableDataTypes.ENCHANTMENT), null).add("compare_to", SerializableDataTypes.INT, (Object)0).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("item_condition", Services.CONDITION.itemDataType()), data -> (type, player) -> {
                AllowAnvilEnchantPower power = new AllowAnvilEnchantPower((PowerType<?>)type, (LivingEntity)player, Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), (Comparison)data.get("comparison"), data.getInt("compare_to"));
                if (data.isPresent("enchantment")) {
                    power.enchantments.add((Enchantment)data.get("enchantment"));
                }
                if (data.isPresent("enchantments")) {
                    power.enchantments.addAll((Collection)data.get("enchantments"));
                }
                return power;
            });
            this.allowCondition();
        }

        @Override
        public Class<AllowAnvilEnchantPower> getPowerClass() {
            return AllowAnvilEnchantPower.class;
        }
    }
}

