/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform.services;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.function.Predicate;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public interface IConditionHelper {
    public SerializableDataType<?> biEntityDataType();

    public void registerBiEntity(String var1, IConditionFactory<Tuple<Entity, Entity>> var2);

    public boolean checkBiEntity(SerializableData.Instance var1, String var2, Entity var3, Entity var4);

    public <C> boolean checkBiEntity(C var1, Entity var2, Entity var3);

    @Nullable
    public Predicate<Tuple<Entity, Entity>> biEntityPredicate(SerializableData.Instance var1, String var2);

    public <T> void writeBiEntityConditionToNbt(CompoundTag var1, String var2, T var3);

    public <T> T readBiEntityConditionFromNbt(CompoundTag var1, String var2);

    public SerializableDataType<?> biomeDataType();

    public void registerBiome(String var1, IConditionFactory<Holder<Biome>> var2);

    public boolean checkBiome(SerializableData.Instance var1, String var2, Holder<Biome> var3);

    @Nullable
    public Predicate<Holder<Biome>> biomePredicate(SerializableData.Instance var1, String var2);

    public <C> boolean checkBiome(C var1, Holder<Biome> var2);

    public SerializableDataType<?> blockDataType();

    public void registerBlock(String var1, IConditionFactory<BlockInWorld> var2);

    public boolean checkBlock(SerializableData.Instance var1, String var2, Level var3, BlockPos var4);

    public <C> boolean checkBlock(C var1, Level var2, BlockPos var3);

    public <T> void writeBlockConditionToNbt(CompoundTag var1, String var2, T var3);

    public <T> T readBlockConditionFromNbt(CompoundTag var1, String var2);

    @Nullable
    public Predicate<BlockInWorld> blockPredicate(SerializableData.Instance var1, String var2);

    public SerializableDataType<?> damageDataType();

    public void registerDamage(String var1, IConditionFactory<Tuple<DamageSource, Float>> var2);

    public boolean checkDamage(SerializableData.Instance var1, String var2, DamageSource var3, float var4);

    public <C> boolean checkDamage(C var1, DamageSource var2, float var3);

    @Nullable
    public Predicate<Tuple<DamageSource, Float>> damagePredicate(SerializableData.Instance var1, String var2);

    public SerializableDataType<?> entityDataType();

    public void registerEntity(String var1, IConditionFactory<Entity> var2);

    public boolean checkEntity(SerializableData.Instance var1, String var2, Entity var3);

    public <C> boolean checkEntity(C var1, Entity var2);

    @Nullable
    public Predicate<Entity> entityPredicate(SerializableData.Instance var1, String var2);

    public SerializableDataType<?> fluidDataType();

    public void registerFluid(String var1, IConditionFactory<FluidState> var2);

    public boolean checkFluid(SerializableData.Instance var1, String var2, FluidState var3);

    public <C> boolean checkFluid(C var1, FluidState var2);

    @Nullable
    public Predicate<FluidState> fluidPredicate(SerializableData.Instance var1, String var2);

    public SerializableDataType<?> itemDataType();

    public void registerItem(String var1, IConditionFactory<ItemStack> var2);

    public boolean checkItem(SerializableData.Instance var1, String var2, Level var3, ItemStack var4);

    public <C> boolean checkItem(C var1, Level var2, ItemStack var3);

    @Nullable
    public Predicate<Tuple<Level, ItemStack>> itemPredicate(SerializableData.Instance var1, String var2);
}

