/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.ModifierData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredModifier;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.ModifierOperation;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.fabric.FabricPowerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.data.ApoliForgeDataTypes;
import net.merchantpug.apugli.mixin.forge.common.accessor.FabricPowerFactoryAccessor;
import net.merchantpug.apugli.network.ApugliPacketHandler;
import net.merchantpug.apugli.network.s2c.SyncSinglePowerPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.platform.services.IPowerHelper;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.power.factory.SpecialPowerFactory;
import net.merchantpug.apugli.registry.ApugliRegisters;
import net.merchantpug.apugli.registry.services.RegistryObject;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@AutoService(value={IPowerHelper.class})
public class ForgePowerHelper
implements IPowerHelper<Holder<ConfiguredPower<?, ?>>> {
    public PowerFactory<?> unwrapSimpleFactory(io.github.apace100.apoli.power.factory.PowerFactory<?> factory) {
        return factory.getWrapped();
    }

    @Override
    public <F extends SimplePowerFactory<?>> Supplier<F> registerFactory(F factory) {
        ApugliRegisters.POWERS.register(factory.getSerializerId().m_135815_(), () -> factory.getWrapped());
        return () -> factory;
    }

    @Override
    public <F extends SpecialPowerFactory<?>> RegistryObject<F> registerFactory(String name, Class<F> factoryClass) {
        return ApugliRegisters.POWERS.register(name, () -> (PowerFactory)Services.load(factoryClass));
    }

    @Override
    public <P> P getPowerFromType(LivingEntity entity, PowerType<?> powerType) {
        return (P)powerType.getConfiguredPower();
    }

    @Override
    public <P extends Power> List<P> getPowers(LivingEntity entity, SimplePowerFactory<P> factory) {
        return IPowerContainer.get((Entity)entity).map(x -> x.getPowers((PowerFactory)((FabricPowerFactory)factory.getWrapped()))).orElseGet(ImmutableList::of).stream().map(holder -> ((FabricPowerFactoryAccessor)((ConfiguredPower)holder.get()).getFactory()).apugli$invokeGetPower((ConfiguredPower)holder.get(), entity)).collect(Collectors.toList());
    }

    @Override
    public <P extends Power> List<P> getPowers(LivingEntity entity, SimplePowerFactory<P> factory, boolean includeInactive) {
        return IPowerContainer.get((Entity)entity).map(x -> x.getPowers((PowerFactory)((FabricPowerFactory)factory.getWrapped()), includeInactive)).orElseGet(ImmutableList::of).stream().map(holder -> ((FabricPowerFactoryAccessor)((ConfiguredPower)holder.get()).getFactory()).apugli$invokeGetPower((ConfiguredPower)holder.get(), entity)).collect(Collectors.toList());
    }

    @Override
    public <P> List<P> getPowers(LivingEntity entity, SpecialPowerFactory<P> factory) {
        return IPowerContainer.get((Entity)entity).map(x -> x.getPowers((PowerFactory)factory)).orElseGet(ImmutableList::of).stream().map(holder -> holder.get()).collect(Collectors.toList());
    }

    @Override
    public <P> List<P> getPowers(LivingEntity entity, SpecialPowerFactory<P> factory, boolean includeInactive) {
        return IPowerContainer.get((Entity)entity).map(x -> x.getPowers((PowerFactory)factory, includeInactive)).orElseGet(ImmutableList::of).stream().map(holder -> holder.get()).collect(Collectors.toList());
    }

    @Override
    public <P extends Power> boolean hasPower(LivingEntity entity, SimplePowerFactory<P> factory) {
        return IPowerContainer.hasPower((Entity)entity, (PowerFactory)factory.getWrapped());
    }

    @Override
    public <P> boolean hasPower(LivingEntity entity, SpecialPowerFactory<P> factory) {
        return IPowerContainer.hasPower((Entity)entity, (PowerFactory)((PowerFactory)factory));
    }

    @Override
    public SerializableDataType<Holder<ConfiguredPower<?, ?>>> getPowerTypeDataType() {
        return ApoliForgeDataTypes.POWER_TYPE;
    }

    @Override
    public <P> boolean isActive(P power, LivingEntity entity) {
        return ((ConfiguredPower)power).isActive((Entity)entity);
    }

    @Override
    public void syncPower(LivingEntity entity, PowerType<?> factory) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.f_8906_ == null) {
                return;
            }
        }
        ApugliPacketHandler.sendS2CTrackingAndSelf(new SyncSinglePowerPacket(entity.m_19879_(), factory.getIdentifier(), factory.getConfiguredPower().serialize(ApoliAPI.getPowerContainer((Entity)entity))), (Entity)entity);
    }

    @Override
    public <P> void syncPower(LivingEntity entity, P power) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.f_8906_ == null) {
                return;
            }
        }
        ConfiguredPower p = (ConfiguredPower)power;
        ApugliPacketHandler.sendS2CTrackingAndSelf(new SyncSinglePowerPacket(entity.m_19879_(), p.getRegistryName(), p.serialize(ApoliAPI.getPowerContainer((Entity)entity))), (Entity)entity);
    }

    @Override
    public OptionalInt getResource(LivingEntity entity, Holder<ConfiguredPower<?, ?>> holder) {
        Optional powerId = holder.m_203543_();
        if (holder.m_203633_()) {
            ConfiguredPower power = (ConfiguredPower)holder.get();
            if (IPowerContainer.get((Entity)entity).resolve().flatMap(container -> {
                if (container == null) {
                    return Optional.empty();
                }
                return powerId.map(arg_0 -> ((IPowerContainer)container).hasPower(arg_0));
            }).orElse(false).booleanValue()) {
                return power.getValue((Entity)entity);
            }
        }
        Apugli.LOG.warn("Failed to get resource for power [{}], because it doesn't hold any resource!", powerId.orElse(null));
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt setResource(LivingEntity entity, Holder<ConfiguredPower<?, ?>> holder, int value) {
        Optional powerId = holder.m_203543_();
        if (holder.m_203633_()) {
            OptionalInt result;
            ConfiguredPower power = (ConfiguredPower)holder.get();
            if (IPowerContainer.get((Entity)entity).resolve().flatMap(container -> {
                if (container == null) {
                    return Optional.empty();
                }
                return powerId.map(arg_0 -> ((IPowerContainer)container).hasPower(arg_0));
            }).orElse(false).booleanValue() && (result = power.assign((Entity)entity, value)).isPresent()) {
                ApoliAPI.synchronizePowerContainer((Entity)entity);
                return result;
            }
        }
        Apugli.LOG.warn("Failed to set resource for power [{}], because it doesn't hold any resource!", powerId.orElse(null));
        return OptionalInt.empty();
    }

    @Override
    public <P> ResourceLocation getPowerFromParameter(P power) {
        Holder holder = (Holder)power;
        if (holder.m_203633_() && holder.m_203543_().isPresent()) {
            return ((ResourceKey)holder.m_203543_().get()).m_135782_();
        }
        return null;
    }

    @Override
    public <P> ResourceLocation getPowerId(P power) {
        return ((ConfiguredPower)power).getRegistryName();
    }

    @Override
    public <P> P getPowerFromId(Entity entity, ResourceLocation powerId) {
        @Nullable Holder holder = ApoliAPI.getPowerContainer((Entity)entity).getPower(powerId);
        if (holder == null || !holder.m_203633_()) {
            return null;
        }
        return (P)holder;
    }

    @Override
    public void grantPower(ResourceLocation powerId, ResourceLocation source, LivingEntity entity) {
        IPowerContainer container = ApoliAPI.getPowerContainer((Entity)entity);
        if (container != null) {
            container.addPower(powerId, source);
            container.sync();
        }
    }

    @Override
    public void revokePower(ResourceLocation powerId, ResourceLocation source, LivingEntity entity) {
        IPowerContainer container = ApoliAPI.getPowerContainer((Entity)entity);
        if (container != null) {
            container.removePower(powerId, source);
            container.sync();
        }
    }

    @Override
    public boolean hasPowerType(ResourceLocation powerId, ResourceLocation source, LivingEntity entity) {
        IPowerContainer container = ApoliAPI.getPowerContainer((Entity)entity);
        if (container != null) {
            return container.hasPower(powerId, source);
        }
        return false;
    }

    @Override
    public Map<ResourceLocation, Double> iterateThroughModifierForResources(LivingEntity entity, List<?> modifiers) {
        HashMap<ResourceLocation, Double> returnMap = new HashMap<ResourceLocation, Double>();
        List<?> originalMods = modifiers;
        for (ConfiguredModifier modifier : originalMods) {
            OptionalDouble doubleValue;
            if (modifier.getData().resource().isPresent() && (doubleValue = this.getResource(entity, (Holder)modifier.getData().resource().get()).stream().mapToDouble(i -> i).min()).isPresent()) {
                returnMap.put(((ResourceKey)((Holder)modifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_(), doubleValue.getAsDouble());
            }
            if (modifier.getData().modifiers().isEmpty()) continue;
            returnMap.putAll(this.iterateThroughModifierForResources(entity, modifier.getData().modifiers()));
        }
        return returnMap;
    }

    @Override
    public Map<Integer, Map<ResourceLocation, Double>> getInBetweenResources(LivingEntity entity, List<?> modifiers, List<?> delayModifiers, double base, Map<ResourceLocation, Double> startingResources) {
        HashMap<Integer, Map<ResourceLocation, Double>> returnMap = new HashMap<Integer, Map<ResourceLocation, Double>>();
        List<ConfiguredModifier<?>> originalMods = modifiers;
        int previousResourceValue = 0;
        HashMap<ResourceLocation, Double> resources = new HashMap<ResourceLocation, Double>(startingResources);
        HashMap<ResourceLocation, Double> targetResources = new HashMap<ResourceLocation, Double>();
        for (Map.Entry entry2 : resources.entrySet()) {
            OptionalInt resourceValue = this.getResource(entity, (Holder<ConfiguredPower<?, ?>>)ApoliAPI.getPowers().m_246971_(ResourceKey.m_135785_((ResourceKey)ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)((ResourceLocation)entry2.getKey()))));
            if (!resourceValue.isPresent()) continue;
            targetResources.put((ResourceLocation)entry2.getKey(), Double.valueOf(resourceValue.getAsInt()));
        }
        if (originalMods.stream().noneMatch(modifier -> modifier.getData().resource().isPresent() && ((Holder)modifier.getData().resource().get()).m_203633_() && startingResources.containsKey(((ResourceKey)((Holder)modifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_()))) {
            return returnMap;
        }
        while (resources.entrySet().stream().anyMatch(entry -> !Objects.equals(targetResources.get(entry.getKey()), entry.getValue()))) {
            for (ConfiguredModifier configuredModifier : originalMods) {
                if (configuredModifier.getData().resource().isPresent() && ((Holder)configuredModifier.getData().resource().get()).m_203633_() && startingResources.containsKey(((ResourceKey)((Holder)configuredModifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_())) {
                    int key = returnMap.keySet().isEmpty() ? 0 : (Integer)returnMap.keySet().stream().max(Integer::compareTo).orElseThrow() + previousResourceValue;
                    returnMap.computeIfAbsent(key, k -> new HashMap());
                    OptionalDouble doubleValue = this.getResource(entity, (Holder)configuredModifier.getData().resource().get()).stream().mapToDouble(i -> i).min();
                    if (doubleValue.isPresent()) {
                        ((Map)returnMap.get(key)).put(((ResourceKey)((Holder)configuredModifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_(), doubleValue.getAsDouble());
                        previousResourceValue = (int)Services.PLATFORM.applyModifiers((Entity)entity, delayModifiers, base);
                    }
                }
                if (configuredModifier.getData().modifiers().isEmpty()) continue;
                Map<Integer, Map<ResourceLocation, Double>> innerMap = this.getInBetweenResources(entity, configuredModifier.getData().modifiers(), delayModifiers, base, startingResources);
                innerMap.forEach((integer, resourceLocationDoubleMap) -> returnMap.merge((Integer)integer, (Map<ResourceLocation, Double>)resourceLocationDoubleMap, (map, map2) -> {
                    map.putAll(map2);
                    return map;
                }));
            }
            ForgePowerHelper.incrementMods(originalMods, resources, targetResources);
        }
        return returnMap;
    }

    @Override
    public double addAllInBetweensOfResourceModifiers(LivingEntity entity, List<?> modifiers, List<?> delayModifiers, double base, Map<ResourceLocation, Double> startingResources) {
        if (startingResources.isEmpty()) {
            return base;
        }
        List<ConfiguredModifier<?>> originalMods = modifiers;
        double currentValue = base;
        HashMap<ResourceLocation, Double> resources = new HashMap<ResourceLocation, Double>(startingResources);
        HashMap<ResourceLocation, Double> targetResources = new HashMap<ResourceLocation, Double>();
        for (Map.Entry entry2 : resources.entrySet()) {
            OptionalInt resourceValue = this.getResource(entity, (Holder<ConfiguredPower<?, ?>>)ApoliAPI.getPowers().m_246971_(ResourceKey.m_135785_((ResourceKey)ApoliDynamicRegistries.CONFIGURED_POWER_KEY, (ResourceLocation)((ResourceLocation)entry2.getKey()))));
            if (!resourceValue.isPresent()) continue;
            targetResources.put((ResourceLocation)entry2.getKey(), Double.valueOf(resourceValue.getAsInt()));
        }
        while (resources.entrySet().stream().anyMatch(entry -> !Objects.equals(((Double)targetResources.get(entry.getKey())).intValue(), ((Double)entry.getValue()).intValue()))) {
            currentValue += this.applyModifierWithSpecificValueAtIndex(entity, modifiers, base, resources);
            ForgePowerHelper.incrementMods(originalMods, resources, targetResources);
        }
        return currentValue;
    }

    private static void incrementMods(List<ConfiguredModifier<?>> modifiers, Map<ResourceLocation, Double> resources, Map<ResourceLocation, Double> targetResources) {
        for (ConfiguredModifier<?> modifier : modifiers) {
            if (!modifier.getData().modifiers().isEmpty()) {
                ForgePowerHelper.incrementMods(modifier.getData().modifiers(), resources, targetResources);
            }
            if (!modifier.getData().resource().isPresent() || !((Holder)modifier.getData().resource().get()).m_203633_() || !resources.containsKey(((ResourceKey)((Holder)modifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_())) continue;
            ResourceLocation resourceId = ((ResourceKey)((Holder)modifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_();
            if (Objects.equals(targetResources.get(resourceId).intValue(), resources.get(resourceId).intValue())) {
                return;
            }
            int increment = targetResources.get(resourceId) < resources.get(resourceId) ? -1 : 1;
            resources.put(resourceId, resources.get(resourceId) + (double)increment);
        }
    }

    @Override
    public double applyModifierWithSpecificValueAtIndex(LivingEntity entity, List<?> modifiers, double base, Map<ResourceLocation, Double> resourceMap) {
        List<ConfiguredModifier<?>> modifierList = modifiers;
        return ModifierUtil.applyModifiers((Entity)entity, this.remapModifiers(modifierList, resourceMap), (double)base);
    }

    private Map<ModifierOperation, List<ConfiguredModifier<?>>> remapModifiers(List<ConfiguredModifier<?>> modifiers, Map<ResourceLocation, Double> resourceMap) {
        HashMap map = new HashMap();
        for (ConfiguredModifier configuredModifier : modifiers) {
            List list = map.computeIfAbsent(configuredModifier.getFactory(), op -> new LinkedList());
            ConfiguredModifier instance = configuredModifier;
            if (configuredModifier.getData().resource().isPresent() && ((Holder)configuredModifier.getData().resource().get()).m_203633_() && resourceMap.containsKey(((ResourceKey)((Holder)configuredModifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_())) {
                instance = new ConfiguredModifier(() -> configuredModifier.getFactory(), new ModifierData(resourceMap.get(((ResourceKey)((Holder)configuredModifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_()).doubleValue(), Optional.empty(), this.remapModifiersInner(configuredModifier.getData().modifiers(), resourceMap)));
            }
            list.add(instance);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private List<ConfiguredModifier<?>> remapModifiersInner(List<ConfiguredModifier<?>> modifiers, Map<ResourceLocation, Double> resourceMap) {
        ArrayList list = new ArrayList();
        for (ConfiguredModifier<?> configuredModifier : modifiers) {
            void var5_5;
            if (configuredModifier.getData().resource().isPresent() && ((Holder)configuredModifier.getData().resource().get()).m_203633_() && resourceMap.containsKey(((ResourceKey)((Holder)configuredModifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_())) {
                ConfiguredModifier configuredModifier2 = new ConfiguredModifier(() -> configuredModifier.getFactory(), new ModifierData(resourceMap.get(((ResourceKey)((Holder)configuredModifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_()).doubleValue(), Optional.empty(), this.remapModifiersInner(configuredModifier.getData().modifiers(), resourceMap)));
            }
            list.add((ConfiguredModifier<?>)var5_5);
        }
        return list;
    }

    @Override
    public Map<ResourceLocation, Double> getClosestToBaseScale(LivingEntity entity, List<?> modifiers, double base) {
        HashMap<ResourceLocation, Double> returnMap = new HashMap<ResourceLocation, Double>();
        List<?> originalMods = modifiers;
        for (ConfiguredModifier modifier : originalMods) {
            if (!modifier.getData().resource().isPresent() || !((Holder)modifier.getData().resource().get()).m_203633_() || entity == null || !ApoliAPI.getPowerContainer((Entity)entity).hasPower((ResourceKey)((Holder)modifier.getData().resource().get()).m_203543_().orElseThrow()) || !((ConfiguredPower)((Holder)modifier.getData().resource().get()).m_203334_()).asVariableIntPower().isPresent()) continue;
            returnMap.putAll(this.handleAdditionToReturnMap(entity, modifier, base, ((ConfiguredPower)((Holder)modifier.getData().resource().get()).get()).getMinimum((Entity)entity).orElse(0), ((ConfiguredPower)((Holder)modifier.getData().resource().get()).get()).getMaximum((Entity)entity).orElse(0)));
        }
        return returnMap;
    }

    private Map<ResourceLocation, Double> handleAdditionToReturnMap(LivingEntity entity, ConfiguredModifier<?> modifier, double base, int min, int max) {
        HashMap<ResourceLocation, Double> currentResourceMap = new HashMap<ResourceLocation, Double>();
        if (modifier.getData().resource().isPresent() && ((Holder)modifier.getData().resource().get()).m_203633_()) {
            for (int i = min; i < max; ++i) {
                for (ConfiguredModifier modifier1 : modifier.getData().modifiers()) {
                    currentResourceMap.putAll(this.handleAdditionToReturnMap(entity, modifier1, base, min, max));
                }
                double distance = Math.abs(this.applyModifierWithSpecificValueAtIndex(entity, List.of(modifier), base, currentResourceMap) - base);
                ResourceLocation thisIndex = ((ResourceKey)((Holder)modifier.getData().resource().get()).m_203543_().orElseThrow()).m_135782_();
                if (currentResourceMap.containsKey(thisIndex) && !(distance < Math.abs((Double)currentResourceMap.get(thisIndex) - base))) continue;
                currentResourceMap.put(thisIndex, Double.valueOf(i));
            }
        }
        return currentResourceMap;
    }
}

