/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c.integration.pehkui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ScaleDataAccess;
import net.merchantpug.apugli.integration.pehkui.ApoliScaleModifier;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.commons.compress.utils.Lists;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public record SyncScalePacket(int entityId, List<ResourceLocation> scaleTypes, ResourceLocation powerId, boolean remove) implements ApugliPacketS2C
{
    public static final ResourceLocation ID = Apugli.asResource("sync_scale");

    @Deprecated
    public static SyncScalePacket addScaleToClient(int entityId, List<ResourceLocation> scaleTypes, ResourceLocation powerId) {
        return new SyncScalePacket(entityId, scaleTypes, powerId, false);
    }

    public static SyncScalePacket removeScaleFromClient(int entityId, List<ResourceLocation> scaleTypes, ResourceLocation powerId) {
        return new SyncScalePacket(entityId, scaleTypes, powerId, true);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.writeInt(this.scaleTypes().size());
        for (int i = 0; i < this.scaleTypes().size(); ++i) {
            buf.m_130085_(this.scaleTypes().get(i));
        }
        buf.m_130085_(this.powerId());
        buf.writeBoolean(this.remove());
    }

    public static SyncScalePacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int typeSize = buf.readInt();
        ArrayList scaleTypes = Lists.newArrayList();
        for (int i = 0; i < typeSize; ++i) {
            ResourceLocation typeId = buf.m_130281_();
            scaleTypes.add(typeId);
        }
        ResourceLocation powerId = buf.m_130281_();
        boolean remove = buf.readBoolean();
        return new SyncScalePacket(entityId, scaleTypes, powerId, remove);
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                if (!Services.PLATFORM.isModLoaded("pehkui")) {
                    Apugli.LOG.warn("Attempted loading SyncScalePacket without Pehkui.");
                    return;
                }
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(SyncScalePacket.this.entityId());
                if (entity == null) {
                    return;
                }
                Object object = ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(SyncScalePacket.this.powerId(), entity);
                if (!(object instanceof ApoliScaleModifier)) {
                    Apugli.LOG.warn("Could not find ApoliScaleModifier for syncing removal from order list.");
                    return;
                }
                ApoliScaleModifier apoliModifier = (ApoliScaleModifier)((Object)object);
                for (ResourceLocation scaleTypeId : SyncScalePacket.this.scaleTypes()) {
                    ScaleType scaleType = (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)scaleTypeId);
                    ScaleData scaleData = scaleType.getScaleData(entity);
                    ((ScaleDataAccess)scaleData).apugli$removeFromApoliScaleModifiers(SyncScalePacket.this.powerId());
                    scaleData.getBaseValueModifiers().remove((Object)apoliModifier);
                    if (SyncScalePacket.this.remove()) continue;
                    ((ScaleDataAccess)scaleData).apugli$addToApoliScaleModifiers(SyncScalePacket.this.powerId());
                    scaleData.getBaseValueModifiers().add(apoliModifier);
                }
            }
        });
    }
}

