/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public record SendParticlesPacket(ParticleOptions effect, boolean force, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float speed, Optional<Vec3> velocity, int count) implements ApugliPacketS2C
{
    public static final ResourceLocation ID = Apugli.asResource("send_particles");

    @Override
    public void encode(FriendlyByteBuf buf) {
        SerializableDataTypes.PARTICLE_EFFECT.send(buf, (Object)this.effect);
        buf.writeBoolean(this.force);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.offsetX);
        buf.writeFloat(this.offsetY);
        buf.writeFloat(this.offsetZ);
        buf.writeBoolean(this.velocity.isPresent());
        this.velocity.ifPresentOrElse(vec3d -> {
            buf.writeDouble(vec3d.f_82479_);
            buf.writeDouble(vec3d.f_82480_);
            buf.writeDouble(vec3d.f_82481_);
        }, () -> buf.writeFloat(this.speed));
        buf.writeInt(this.count);
    }

    public static SendParticlesPacket decode(FriendlyByteBuf buf) {
        Vec3 velocity;
        float speed;
        ParticleOptions effect = (ParticleOptions)SerializableDataTypes.PARTICLE_EFFECT.receive(buf);
        boolean force = buf.readBoolean();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float offsetX = buf.readFloat();
        float offsetY = buf.readFloat();
        float offsetZ = buf.readFloat();
        boolean hasVelocity = buf.readBoolean();
        if (hasVelocity) {
            speed = 0.0f;
            velocity = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        } else {
            speed = buf.readFloat();
            velocity = null;
        }
        int count = buf.readInt();
        return new SendParticlesPacket(effect, force, x, y, z, offsetX, offsetY, offsetZ, speed, Optional.ofNullable(velocity), count);
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null) {
                    Apugli.LOG.info("Could not find world to send particles to.");
                    return;
                }
                if (SendParticlesPacket.this.count == 0) {
                    try {
                        double d = SendParticlesPacket.this.velocity.isPresent() ? SendParticlesPacket.this.velocity.get().f_82479_ : (double)(SendParticlesPacket.this.speed * SendParticlesPacket.this.offsetX);
                        double e = SendParticlesPacket.this.velocity.isPresent() ? SendParticlesPacket.this.velocity.get().f_82480_ : (double)(SendParticlesPacket.this.speed * SendParticlesPacket.this.offsetY);
                        double f = SendParticlesPacket.this.velocity.isPresent() ? SendParticlesPacket.this.velocity.get().f_82481_ : (double)(SendParticlesPacket.this.speed * SendParticlesPacket.this.offsetZ);
                        world.m_6493_(SendParticlesPacket.this.effect, SendParticlesPacket.this.force, SendParticlesPacket.this.x, SendParticlesPacket.this.y, SendParticlesPacket.this.z, d, e, f);
                    }
                    catch (Throwable throwable) {
                        Apugli.LOG.warn("Could not spawn particle effect {}", (Object)SendParticlesPacket.this.effect);
                    }
                } else {
                    for (int i = 0; i < SendParticlesPacket.this.count; ++i) {
                        double g = world.f_46441_.m_188583_() * (double)SendParticlesPacket.this.offsetX;
                        double h = world.f_46441_.m_188583_() * (double)SendParticlesPacket.this.offsetY;
                        double j = world.f_46441_.m_188583_() * (double)SendParticlesPacket.this.offsetZ;
                        double k = SendParticlesPacket.this.velocity.map(v -> v.f_82479_).orElseGet(() -> world.f_46441_.m_188583_() * (double)SendParticlesPacket.this.speed);
                        double l = SendParticlesPacket.this.velocity.map(v -> v.f_82480_).orElseGet(() -> world.f_46441_.m_188583_() * (double)SendParticlesPacket.this.speed);
                        double m = SendParticlesPacket.this.velocity.map(v -> v.f_82481_).orElseGet(() -> world.f_46441_.m_188583_() * (double)SendParticlesPacket.this.speed);
                        try {
                            world.m_6493_(SendParticlesPacket.this.effect, SendParticlesPacket.this.force, SendParticlesPacket.this.x + g, SendParticlesPacket.this.y + h, SendParticlesPacket.this.z + j, k, l, m);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            Apugli.LOG.warn("Could not spawn particle effect {}", (Object)SendParticlesPacket.this.effect);
                            return;
                        }
                    }
                }
            }
        });
    }
}

