/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import com.mojang.serialization.DynamicOps;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.capability.entity.KeyPressCapability;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record AddKeyToCheckPacket(int entityId, IActivePower.Key key) implements ApugliPacketS2C
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        IActivePower.Key.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.key()).resultOrPartial(msg -> {
            buf.writeBoolean(false);
            Apugli.LOG.error("Failed to encode previously active power key for syncing keys to check. {}", (Object)this.key());
        }).ifPresent(tag -> {
            buf.writeBoolean(true);
            buf.m_130079_((CompoundTag)tag);
        });
    }

    public static AddKeyToCheckPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        if (buf.readBoolean()) {
            CompoundTag tag = buf.m_130260_();
            IActivePower.Key key = (IActivePower.Key)IActivePower.Key.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(msg -> Apugli.LOG.error("Failed to decode active power key while syncing keys to check. {}", msg)).orElseThrow();
            return new AddKeyToCheckPacket(entityId, key);
        }
        return null;
    }

    @Override
    public ResourceLocation getFabricId() {
        throw new RuntimeException("ApugliPacket#getFabricId is not meant to be used in Forge specific packets.");
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId());
            if (!(entity instanceof Player)) {
                Apugli.LOG.warn("Could not a client player to add a key to check with.");
                return;
            }
            Player player = (Player)entity;
            if (!player.m_7578_()) {
                return;
            }
            player.getCapability(KeyPressCapability.INSTANCE).ifPresent(capability -> capability.addKeyToCheck(this.key()));
        });
    }
}

