/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.capability.entity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.merchantpug.apugli.capability.entity.IHitsOnTargetCapability;
import net.merchantpug.apugli.network.ApugliPacketHandler;
import net.merchantpug.apugli.network.s2c.SyncHitsOnTargetCapabilityPacket;
import net.merchantpug.apugli.util.ApugliConfigs;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HitsOnTargetCapability
implements IHitsOnTargetCapability,
ICapabilityProvider {
    private Map<Integer, Tuple<Integer, Integer>> previousHits = new HashMap<Integer, Tuple<Integer, Integer>>();
    private final Map<Integer, Tuple<Integer, Integer>> hits = new HashMap<Integer, Tuple<Integer, Integer>>();
    private final LivingEntity provider;
    public static final Capability<HitsOnTargetCapability> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<HitsOnTargetCapability>(){});
    private final LazyOptional<HitsOnTargetCapability> thisOptional = LazyOptional.of(() -> this);

    public HitsOnTargetCapability(LivingEntity provider) {
        this.provider = provider;
    }

    @Override
    public Map<Integer, Tuple<Integer, Integer>> getHits() {
        return this.hits;
    }

    @Override
    public Map<Integer, Tuple<Integer, Integer>> getPreviousHits() {
        return this.previousHits;
    }

    @Override
    public void setHits(int entityId, int hitValue, int timer) {
        this.hits.put(entityId, (Tuple<Integer, Integer>)new Tuple((Object)hitValue, (Object)timer));
    }

    @Override
    public void removeHits(int entityId) {
        this.hits.remove(entityId);
    }

    @Override
    public void serverTick() {
        Iterator<Map.Entry<Integer, Tuple<Integer, Integer>>> it = this.hits.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Tuple<Integer, Integer>> entry = it.next();
            Entity entity = this.provider.m_9236_().m_6815_(entry.getKey().intValue());
            int hitAmount = (Integer)entry.getValue().m_14418_();
            int currentTime = (Integer)entry.getValue().m_14419_();
            if (entity == null || !entity.m_6084_() || currentTime > ApugliConfigs.SERVER.hitsOnTargetOptions.getResetTimerTicks()) {
                it.remove();
                if (it.hasNext()) continue;
                continue;
            }
            entry.setValue((Tuple<Integer, Integer>)new Tuple((Object)hitAmount, (Object)(currentTime + 1)));
        }
        this.previousHits = this.hits;
    }

    @Override
    public void setFrom(IHitsOnTargetCapability cap) {
        this.previousHits.clear();
        this.previousHits.putAll(cap.getPreviousHits());
        this.hits.clear();
        this.hits.putAll(cap.getHits());
    }

    public void sync() {
        if (this.provider.m_9236_().f_46443_) {
            return;
        }
        ApugliPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.provider), (Object)new SyncHitsOnTargetCapabilityPacket(this.provider.m_19879_(), this.hits));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.thisOptional);
    }
}

