/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.util.RaycastUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaycastAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("distance", SerializableDataTypes.DOUBLE, null).add("direction", SerializableDataTypes.VECTOR, null).add("space", ApoliDataTypes.SPACE, (Object)Space.WORLD).add("pierce", SerializableDataTypes.BOOLEAN, (Object)false).add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE, null).add("spacing", SerializableDataTypes.DOUBLE, (Object)0.5).add("block_action", Services.ACTION.blockDataType(), null).add("block_condition", Services.CONDITION.blockDataType(), null).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("target_action", Services.ACTION.entityDataType(), null).add("target_condition", Services.CONDITION.entityDataType(), null).add("self_action", Services.ACTION.entityDataType(), null);
    }

    @Override
    public void execute(SerializableData.Instance data, Entity entity) {
        HitResult.Type entityHitResultType;
        double blockDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getReachDistance(entity);
        BlockHitResult blockHitResult = RaycastUtil.raycastBlock(entity, blockDistance, (Vec3)data.get("direction"), (Space)data.get("space"));
        HitResult.Type blockHitResultType = blockHitResult.m_6662_();
        double entityDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getAttackRange(entity);
        EntityHitResult entityHitResult = RaycastUtil.raycastEntity(blockHitResult, entity, entityDistance, (Vec3)data.get("direction"), (Space)data.get("space"), null);
        HitResult.Type type = entityHitResultType = entityHitResult != null ? entityHitResult.m_6662_() : null;
        if (data.getBoolean("pierce")) {
            List<EntityHitResult> list = RaycastUtil.raycastEntities(entity, traceEntity -> !traceEntity.m_5833_() && traceEntity.m_6087_(), entityDistance, (Vec3)data.get("direction"), (Space)data.get("space"));
            this.handlePierce(data, entity, list);
            return;
        }
        if (entityHitResultType == HitResult.Type.ENTITY) {
            this.createParticlesAtHitPos(data, entity, (HitResult)entityHitResult);
            this.onHitEntity(data, entity, entityHitResult, false);
            return;
        }
        if (blockHitResultType == HitResult.Type.BLOCK) {
            this.createParticlesAtHitPos(data, entity, (HitResult)blockHitResult);
            this.onHitBlock(data, entity, blockHitResult);
        }
    }

    protected void createParticlesAtHitPos(SerializableData.Instance data, Entity entity, HitResult hitResult) {
        if (!data.isPresent("particle") || entity.m_9236_().m_5776_()) {
            return;
        }
        ParticleOptions particleEffect = (ParticleOptions)data.get("particle");
        double distanceTo = hitResult.m_82448_(entity);
        for (double d = data.getDouble("spacing"); d < distanceTo; d += data.getDouble("spacing")) {
            double lerpValue = Mth.m_14008_((double)(d / distanceTo), (double)0.0, (double)1.0);
            ((ServerLevel)entity.m_9236_()).m_8767_(particleEffect, Mth.m_14139_((double)lerpValue, (double)entity.m_20185_(), (double)hitResult.m_82450_().m_7096_()), Mth.m_14139_((double)lerpValue, (double)entity.m_20186_(), (double)hitResult.m_82450_().m_7098_()), Mth.m_14139_((double)lerpValue, (double)entity.m_20189_(), (double)hitResult.m_82450_().m_7094_()), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void handlePierce(SerializableData.Instance data, Entity entity, List<EntityHitResult> list) {
        if (list.isEmpty()) {
            return;
        }
        Entity previousEntity = entity;
        for (EntityHitResult result : list) {
            this.createParticlesAtHitPos(data, previousEntity, (HitResult)result);
            previousEntity = result.m_82443_();
            this.onHitEntity(data, entity, result, true);
        }
        this.executeSelfAction(data, entity);
    }

    protected void executeSelfAction(SerializableData.Instance data, Entity entity) {
        if (!data.isPresent("self_action") || !entity.m_6084_()) {
            return;
        }
        Services.ACTION.executeEntity(data, "self_action", entity);
    }

    protected void onHitBlock(SerializableData.Instance data, Entity entity, BlockHitResult result) {
        if (!data.isPresent("block_action") || !Services.CONDITION.checkBlock(data, "block_condition", entity.m_9236_(), result.m_82425_())) {
            return;
        }
        Services.ACTION.executeBlock(data, "block_action", entity.m_9236_(), result.m_82425_(), result.m_82434_());
        this.executeSelfAction(data, entity);
    }

    protected void onHitEntity(SerializableData.Instance data, Entity actor, EntityHitResult result, boolean calledThroughPierce) {
        boolean hasTargetAction = data.isPresent("target_action");
        boolean hasBiEntityAction = data.isPresent("bientity_action");
        if (Services.CONDITION.checkEntity(data, "target_condition", actor)) {
            return;
        }
        Entity target = result.m_82443_();
        if (!Services.CONDITION.checkBiEntity(data, "bientity_condition", actor, target)) {
            return;
        }
        if (hasTargetAction) {
            Services.ACTION.executeEntity(data, "target_action", actor);
        }
        if (hasBiEntityAction) {
            Services.ACTION.executeBiEntity(data, "bientity_action", actor, target);
        }
        if (calledThroughPierce) {
            return;
        }
        this.executeSelfAction(data, actor);
    }
}

